package com.bokesoft.yes.mid.web.ui.load.panel;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BasePanelJSONBuilder;
import com.bokesoft.yigo.common.def.DirectionType;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.common.def.TabMode;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.MetaTabPanel;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutTabItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaTabLayout;
import com.bokesoft.yigo.tools.ve.VE;

public class TabPanelJSONBuilder extends BasePanelJSONBuilder<MetaTabPanel> {

	@Override
	public void load(VE ve,
			IRootJSONBuilder<AbstractMetaObject> builder,
			JSONObject json, MetaForm metaForm, MetaTabPanel meta) throws Throwable {
		super.load(ve, builder, json, metaForm, meta);
		json.put(JSONConstants.BASEPANEL_LAYOUT, LayoutType.STR_LAYOUT_TAB);
		MetaTabLayout layoutImpl = meta.newLayout();
		Iterator<MetaLayoutTabItem> it = layoutImpl.iterator();
		MetaLayoutTabItem metaTabItem = null;
		MetaComponent metaComponent = null;
		JSONArray items = new JSONArray();
		JSONObject childJSON = null;
		while (it.hasNext()) {
			metaTabItem = it.next();
			metaComponent = meta.getComponent(metaTabItem.getKey());
			childJSON = builder.build(ve, builder, metaForm, metaComponent);
			items.put(childJSON);
		}
		json.put(JSONConstants.COMMON_ITEMS, items);
		JSONHelper.writeToJSON(json, JSONConstants.TABPANEL_TABPOSITION, meta.getTabPosition(), DirectionType.TOP);
		JSONHelper.writeToJSON(json, JSONConstants.TABPANEL_TABMODE, meta.getTabMode(), TabMode.Fixed);
		JSONHelper.writeToJSON(json, JSONConstants.TABPANEL_INDICATORHEIGHT, 
				meta.getIndicatorHeight() == null ? null : meta.getIndicatorHeight().toString(), null);
		JSONHelper.writeToJSON(json, JSONConstants.TABPANEL_INDICATORCOLOR, meta.getIndicatorColor(), "");
		JSONHelper.writeToJSON(json, JSONConstants.TABPANEL_SHOWHEAD, meta.isShowHead(), true);
		MetaBaseScript itemChanged = meta.getItemChanged();
		if( itemChanged != null ) {
			json.put(JSONConstants.TABPANEL_ITEMCHANGED, itemChanged.getContent().trim());
		}
	}	
}
