package com.bokesoft.yes.mid.web.ui.load.panel;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BasePanelJSONBuilder;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.MetaFlowLayoutPanel;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFlowLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutFlowIndex;
import com.bokesoft.yigo.tools.ve.VE;

public class FlowLayoutPanelJSONBuilder extends BasePanelJSONBuilder<MetaFlowLayoutPanel> {

	@Override
	public void load(VE ve,
			IRootJSONBuilder<AbstractMetaObject> builder,
			JSONObject json, MetaForm metaForm, MetaFlowLayoutPanel meta)
			throws Throwable {
		super.load(ve, builder, json, metaForm, meta);
		json.put(JSONConstants.BASEPANEL_LAYOUT, LayoutType.STR_LAYOUT_FLOW);
		MetaFlowLayout layoutImpl = meta.newLayout();
		Iterator<MetaLayoutFlowIndex> it = layoutImpl.iterator();
		MetaLayoutFlowIndex item = null;
		MetaComponent metaComponent = null;
		JSONArray items = new JSONArray();
		JSONObject childJSON = null;
		while (it.hasNext()) {
			item = it.next();
			metaComponent = meta.getComponent(item.getKey());
			childJSON = builder.build(ve, builder, metaForm, metaComponent);
			items.put(childJSON);
		}
		json.put(JSONConstants.COMMON_ITEMS, items);
	}
	
}
