package com.bokesoft.yes.mid.web.ui.load.panel;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BasePanelJSONBuilder;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.MetaFlexFlowLayoutPanel;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFlexFlowLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutFlowIndex;
import com.bokesoft.yigo.tools.ve.VE;

public class FlexFlowLayoutPanelJSONBuilder extends BasePanelJSONBuilder<MetaFlexFlowLayoutPanel> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder,
			JSONObject json, MetaForm metaForm, MetaFlexFlowLayoutPanel meta) throws Throwable {
		super.load(ve, builder, json, metaForm, meta);
		json.put(JSONConstants.BASEPANEL_LAYOUT, LayoutType.STR_LAYOUT_FLEXFLOW);
		MetaFlexFlowLayout layoutImpl = meta.newLayout();
		Iterator<MetaLayoutFlowIndex> it = layoutImpl.iterator();
		MetaLayoutFlowIndex layoutItem = null;
		MetaComponent metaComponent = null;
		JSONArray items = new JSONArray();
		JSONObject childJSON = null;
		while (it.hasNext()) {
			layoutItem = it.next();
			metaComponent = meta.getComponent(layoutItem.getKey());
			childJSON = builder.build(ve, builder, metaForm, metaComponent);
			DefSize height = layoutItem.getHeight();
			if (height != null) {
				if (height.getSizeType() == DefSize.Fix) {
					JSONHelper.writeToJSON(childJSON, JSONConstants.COMMON_HEIGHT, height.getSize(), 0);
				} else if (height.getSizeType() == DefSize.Ratio) {
					JSONHelper.writeToJSON(childJSON, JSONConstants.COMMON_HEIGHT, height.toString(), "0");
				} else if (height.getSizeType() == DefSize.Pref) {
					JSONHelper.writeToJSON(childJSON, JSONConstants.COMMON_HEIGHT, DefSize.STR_Pref, "");
				}
			}
			items.put(childJSON);
		}
		json.put(JSONConstants.COMMON_ITEMS, items);
	}
	
}
