package com.bokesoft.yes.mid.web.ui.load.panel;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BasePanelJSONBuilder;
import com.bokesoft.yigo.common.def.DirectionType;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.MetaBorderLayoutPanel;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaBorderLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutDirection;
import com.bokesoft.yigo.tools.ve.VE;

public class BorderLayoutPanelJSONBuilder extends BasePanelJSONBuilder<MetaBorderLayoutPanel> {

	@Override
	public void load(VE ve,
			IRootJSONBuilder<AbstractMetaObject> builder,
			JSONObject json, MetaForm metaForm, MetaBorderLayoutPanel meta)
			throws Throwable {
		super.load(ve, builder, json, metaForm, meta);
		json.put(JSONConstants.BASEPANEL_LAYOUT, LayoutType.STR_LAYOUT_BORDER);
		MetaBorderLayout layoutImpl = meta.newLayout();
		MetaComponent metaComponent = null;
		int componentCount = meta.getComponentCount();
		JSONArray items = new JSONArray();
		JSONObject childJSON = null;
		
		// 为了方便前台焦点处理
		for (int i = 0; i < componentCount; ++i) {
			metaComponent = meta.getComponent(i);
			childJSON = builder.build(ve, builder, metaForm, metaComponent);
			
			MetaLayoutDirection item = layoutImpl.get(metaComponent.getKey());
			switch (item.getValue()) {
			case DirectionType.TOP:
				JSONHelper.writeToJSON(childJSON, JSONConstants.COMMON_REGION, DirectionType.toString(DirectionType.TOP), "");
				break;
			case DirectionType.BOTTOM:
				JSONHelper.writeToJSON(childJSON, JSONConstants.COMMON_REGION, DirectionType.toString(DirectionType.BOTTOM), "");
				break;
			case DirectionType.LEFT:
				JSONHelper.writeToJSON(childJSON, JSONConstants.COMMON_REGION, DirectionType.toString(DirectionType.LEFT), "");
				break;
			case DirectionType.RIGHT:
				JSONHelper.writeToJSON(childJSON, JSONConstants.COMMON_REGION, DirectionType.toString(DirectionType.RIGHT), "");
				break;
			case DirectionType.CENTER:
				JSONHelper.writeToJSON(childJSON, JSONConstants.COMMON_REGION, DirectionType.toString(DirectionType.CENTER), "");
				break;
			}
			items.put(childJSON);
		}
		json.put(JSONConstants.COMMON_ITEMS, items);
	}

}
