package com.bokesoft.yes.mid.web.ui.load.navigationbar;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.BarItemLocation;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaNavigationBarItem;
import com.bokesoft.yigo.tools.ve.VE;

public class NavigationBarItemJSONBuilder extends AbstractJSONBuilder<MetaNavigationBarItem>{

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaNavigationBarItem meta) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, meta.getCaption(), "");
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONBARITEM_LOCATION, BarItemLocation.toString(meta.getLocation()), "");
		if(meta.getRoot() != null){
			JSONObject rootObj = builder.build(ve, builder, metaForm, meta.getRoot());
			json.put(JSONConstants.BODY_ROOT, rootObj);
		}
	}

}
