package com.bokesoft.yes.mid.web.ui.load.control.wizardlist;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.WizardItemListSourceType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.wizardlist.MetaWizardItemList;
import com.bokesoft.yigo.tools.ve.VE;

public class WizardItemListJSONBuilder extends AbstractJSONBuilder<MetaWizardItemList>{

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaWizardItemList meta) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.WIZARDITEMLIST_TABLEKEY, meta.getTableKey(), "");
		JSONHelper.writeToJSON(json, JSONConstants.WIZARDITEMLIST_SOURCETYPE, WizardItemListSourceType.toString(meta.getSourceType()), 
				WizardItemListSourceType.STR_Data);
		if(!meta.getFormulaItems().isEmpty()){
			json.put(JSONConstants.WIZARDITEMLIST_FORMULAITEMS, meta.getFormulaItems().getContent().trim());
		}
	}
}
