package com.bokesoft.yes.mid.web.ui.load.control.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.common.def.EditorImeOptions;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.MetaTextEditor;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextEditorProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class TextEditorPropertiesJSONBuilder extends PropertiesJSONBuilder<MetaTextEditorProperties> {

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm, MetaTextEditorProperties meta, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_TEXTCASE, meta.getCaseType(), MetaTextEditor.CASETYPE_NONE);		
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_EMBEDTEXT, builder.getString(GroupKeyTable.STR_EMBED, "", key, meta.getEmbedText()), "");
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_HOLDFOCUS, meta.isHoldFocus(), false);
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_ICON, meta.getIcon(), "");
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_INVALIDCHARS, meta.getInvalidChars(), "");
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_MASK, meta.getMask(), "");
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_MAXLENGTH, meta.getMaxLength(), 255);
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_PREICON, meta.getPreIcon(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMPONENT_PROMPTTEXT, builder.getString(GroupKeyTable.STR_PROMPT, "", key, meta.getPromptText()), "");
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_SELECTONFOCUS, meta.isSelectOnFocus(), true);
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_TRIM, meta.isTrim(), false);
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_EMBEDTEXTSIZE, meta.getEmbedTextSize(), -1);
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_EMBEDTEXTCOLOR, meta.getEmbedTextColor(), "");
		JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_IMEOPTIONS, EditorImeOptions.toString(meta.getImeOptions()), "");
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_SUFFIX, meta.getSuffix(), "");
		JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_PREFIX, meta.getPrefix(), "");
		MetaBaseScript onFocus = meta.getOnFocus();
		if(onFocus != null) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnFocus, onFocus.getContent(), "");
		}
		MetaBaseScript keyEnter = meta.getKeyEnter();
		if(keyEnter != null) {
			JSONHelper.writeToJSON(json, JSONConstants.Event_KeyEnter, keyEnter.getContent(), "");
		}
	}
}
