package com.bokesoft.yes.mid.web.ui.load.control.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.PopButtonLocationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaPopButtonProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class PopButtonPropertiesJSONBuilder extends ButtonPropertiesJSONBuilder {

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaButtonProperties meta, String key) throws Throwable {
		super.loadImpl(ve, builder, json, metaForm, meta, key);
		MetaPopButtonProperties metaPop = (MetaPopButtonProperties) meta;
		JSONHelper.writeToJSON(json, JSONConstants.POPBUTTON_LOCATION,
				PopButtonLocationType.toString(metaPop.getLocation()), PopButtonLocationType.STR_LEFT);
		if (metaPop.getRoot() != null) {
			JSONObject rootJSON = builder.build(ve, builder, metaForm, metaPop.getRoot());
			json.put(JSONConstants.POPBUTTON_ROOT, rootJSON);
		}
	}
}
