package com.bokesoft.yes.mid.web.ui.load.control.grid;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.ColumnType;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.grid.MetaColumnExpand;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumnCollection;
import com.bokesoft.yigo.tools.ve.VE;

public class GridColumnJSONBuilder extends AbstractJSONBuilder<MetaGridColumn> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaGridColumn meta) throws Throwable {

		json.put("key", meta.getKey());
		// 列扩展配置在加载metaForm时会更改key的属性，传递组件原始key
//		json.put("metaGridColumnKey", meta.getMetaGridColumnKey());
		
		String caption = builder.getString(GroupKeyTable.STR_GRIDCOLUMN, "", meta.getOldKey(), meta.getCaption());
		json.put("caption", caption);
		json.put("formulaCaption", meta.getFormulaCaption());
		json.put("width", meta.getWidth());
		json.put("sortable", meta.getSortable());
		json.put("visible", meta.getVisible());
		json.put("visibleDependency", meta.getVisibleDependency());
		json.put("columnType", ColumnType.toString(meta.getColumnType()));
		MetaColumnExpand columnExpand = meta.getColumnExpand();
		if (columnExpand != null) {
			//json.put("columnExpand", columnExpand.toJSON());
		}
		JSONArray columnArray = new JSONArray();
		MetaGridColumnCollection collection = meta.getColumnCollection();
		if (collection != null) {
			MetaGridColumn column = null;
			JSONObject obj = null;
			for (int i = 0,size = collection.size(); i < size; i++) {
				column = collection.get(i);
				obj = builder.build(ve, builder, metaForm, column);
				obj.put("parentKey", meta.getKey());
				columnArray.put(obj);
			}
			json.put("columns", columnArray);
		}
	}
}
