package com.bokesoft.yes.mid.web.ui.load.control.editview;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.PropertiesJSONBuilderMap;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.GroupKeyTable;
import com.bokesoft.yigo.common.def.RoundingMode;
import com.bokesoft.yigo.common.def.TargetShowType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaFont;
import com.bokesoft.yigo.meta.form.component.MetaFormat;
import com.bokesoft.yigo.meta.form.component.control.MetaDataBinding;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDatePickerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaHyperLinkProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaLabelProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaMultiStateButtonProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaNumberEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaStateItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaStateItemCollection;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextAreaProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTextEditorProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTimePickerProperties;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaToggleButtonProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class EditViewColumnJSONBuilder extends AbstractJSONBuilder<MetaEditViewColumn> {

	
	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder,
			 JSONObject json, MetaForm metaForm, MetaEditViewColumn meta) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_KEY, meta.getKey(), "");
		String caption = builder.getString(GroupKeyTable.STR_LISTVIEWCOLUMN, "", meta.getKey(), meta.getCaption());
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_CAPTION, caption, "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_WIDTH, meta.getWidth().toString(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_COLUMNKEY, meta.getDataColumnKey(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DEFAULTVALUE, meta.getDefaultValue(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_DEFAULTFORMULAVALUE, meta.getDefaultFormulaValue(), "");
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_COLUMN_TYPE, meta.getColumnType(), -1);
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_COLUMN_IS_SELECT, meta.isSelect(), false);
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_COLUMN_SINGLESELECT, meta.singleSelect(), false);
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_COLUMN_WRAPTEXT, meta.isWrapText(), false);
		JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_COLUMN_SORTABLE, meta.isSortable(), false);
		
		JSONObject metaJSON = new JSONObject();
		JSONHelper.writeToJSON(metaJSON, JSONConstants.COMMON_ENABLE, meta.getEnable(), "");
		JSONHelper.writeToJSON(metaJSON, JSONConstants.COMMON_VISIBLE, meta.getVisible(), "");
		json.put(JSONConstants.LISTVIEW_COLUMN_META, metaJSON);
		
		MetaFormat formatMeta = meta.getFormat();
		JSONObject formatJSON = new JSONObject();
		if (formatMeta != null) {
			JSONHelper.writeToJSON(formatJSON, JSONConstants.FORMAT_FORECOLOR, formatMeta.getForeColor(), "");
			JSONHelper.writeToJSON(formatJSON, JSONConstants.FORMAT_BACKCOLOR, formatMeta.getBackColor(), "");
			JSONHelper.writeToJSON(formatJSON, JSONConstants.FORMAT_HIGHLIGHTBACKCOLOR, formatMeta.getHighlightBackColor(), "");
			JSONHelper.writeToJSON(formatJSON, JSONConstants.FORMAT_HALIGN, formatMeta.getHAlign(), -1);
			JSONHelper.writeToJSON(formatJSON, JSONConstants.FORMAT_VALIGN, formatMeta.getVAlign(), -1);
			JSONObject fontJSON = new JSONObject();
			MetaFont fontMeta = formatMeta.getFont();
			if(fontMeta != null) {
				JSONHelper.writeToJSON(fontJSON, JSONConstants.FONT_NAME, fontMeta.getName(), "");
				JSONHelper.writeToJSON(fontJSON, JSONConstants.FONT_SIZE, fontMeta.getSize(), -1);
				JSONHelper.writeToJSON(fontJSON, JSONConstants.FONT_BOLD, fontMeta.isBold(), false);
				JSONHelper.writeToJSON(fontJSON, JSONConstants.FONT_ITALIC, fontMeta.isItalic(), false);
			}
			formatJSON.put(JSONConstants.FORMAT_FONT, fontJSON);
		}
		
		json.put(JSONConstants.COMMON_FORMAT, formatJSON);

		JSONObject metaListViewColumnh = new JSONObject();
		MetaBaseScript script = null;
		AbstractMetaObject metaColumn = meta.getProperties();
		
		PropertiesJSONBuilder<AbstractMetaObject> propertesbuilder = null;
		
        switch (meta.getColumnType()) {
		case ControlType.TEXTEDITOR:
        			MetaTextEditorProperties metaTextEditor = (MetaTextEditorProperties) metaColumn;
        			JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_MAXLENGTH, metaTextEditor.getMaxLength(),0);
        			JSONHelper.writeToJSON(json,JSONConstants.TEXTEDITOR_INVALIDCHARS,  metaTextEditor.getInvalidChars() ,"" );
        			JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_TEXTCASE, metaTextEditor.getCaseType(),0);
        			break;
               case ControlType.LABEL:
            	   		MetaLabelProperties metalable=(MetaLabelProperties) metaColumn;
        			JSONHelper.writeToJSON(json,JSONConstants.LABEL_ICON,  metalable.getIcon() ,"" );
        			break;
                case ControlType.CHECKBOX:
                    MetaDataBinding databinding = meta.getDataBinding();
                    if (databinding != null){
                        MetaBaseScript valuechanged = databinding.getValueChangedNode();
                        if (valuechanged != null) {
                        	JSONHelper.writeToJSON(json,JSONConstants.COMMON_VALUECHANGED,  valuechanged.getContent().trim() ,"" );                        	
                        }
                    }
        			break;
                case ControlType.HYPERLINK:
        			MetaHyperLinkProperties metahyper=(MetaHyperLinkProperties) metaColumn;
        			JSONHelper.writeToJSON(json,JSONConstants.HYPERLINK_URL, metahyper.getURL(),"" );
        			JSONHelper.writeToJSON(json, JSONConstants.HYPERLINK_FORMULAURL,  metahyper.getFormulaURL(), "");
        			JSONHelper.writeToJSON(json,JSONConstants.HYPERLINK_TARGETSHOWTYPE, metahyper.getTargetShowType(), TargetShowType.TARGETSHOWTYPE_NEW );
        			script = ((MetaHyperLinkProperties)metaColumn).getOnClick();
        			break;
                case ControlType.BUTTON:
                	MetaButtonProperties metabutton=(MetaButtonProperties) metaColumn;
        			JSONHelper.writeToJSON(json,JSONConstants.BUTTON_ICON, metabutton.getIcon(),"" );
        			script = ((MetaButtonProperties)metaColumn).getOnClick();
        			break;
                case ControlType.TOGGLEBUTTON:
                	MetaToggleButtonProperties metaToggleButton = (MetaToggleButtonProperties)metaColumn;
        			JSONHelper.writeToJSON(json,JSONConstants.COLLAPSE_TEXTON, metaToggleButton.getTextOn(),"" );
        			JSONHelper.writeToJSON(json,JSONConstants.COLLAPSE_TEXTOFF, metaToggleButton.getTextOff(),"" );
        			JSONHelper.writeToJSON(json,JSONConstants.TOGGLEBUTTON_ICON, metaToggleButton.getIcon(),"" );
        			JSONHelper.writeToJSON(json,JSONConstants.TOGGLEBUTTON_ICONON, metaToggleButton.getIconOn(),"" );
        			JSONHelper.writeToJSON(json,JSONConstants.TOGGLEBUTTON_ICONOFF, metaToggleButton.getIconOff(),"" );
        			JSONHelper.writeToJSON(json,JSONConstants.BUTTON_ICONLOCATION, metaToggleButton.getIconLocation(), -1);
        			script = metaToggleButton.getOnClick();
                	break;
                case ControlType.MULTISTATEBUTTON:
                	MetaMultiStateButtonProperties metaMultiStateButton = (MetaMultiStateButtonProperties)metaColumn;
        			JSONHelper.writeToJSON(json,JSONConstants.BUTTON_ICONLOCATION, metaMultiStateButton.getIconLocation(), -1);
        			MetaStateItemCollection collection = metaMultiStateButton.getItemCollection();
        			if(collection != null){
        				JSONArray array = this.buildItems(meta.getKey(), collection, builder);
        				JSONHelper.writeToJSON(json, JSONConstants.MULTISTATEBUTTON_STATEITEM, array);
        			}
        			script = metaMultiStateButton.getOnClick();
                	break;
                case ControlType.DATEPICKER:
                	MetaDatePickerProperties metaDatePicker = (MetaDatePickerProperties) metaColumn;
        			JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_COLUMN_ONLYDATE, metaDatePicker.isOnlyDate(), false);
        			JSONHelper.writeToJSON(json, JSONConstants.LISTVIEW_COLUMN_FORMAT, metaDatePicker.getDateFormat(), "");
        			break;
                case ControlType.DICT:
                	MetaDictProperties metaDict = (MetaDictProperties) metaColumn;
        			JSONHelper.writeToJSON(json,JSONConstants.DICT_MULTISELECT, metaDict.isAllowMultiSelection(), false );
        			JSONHelper.writeToJSON(json, JSONConstants.DICT_ITEMKEY, metaDict.getItemKey(), "");
        			break;
                case ControlType.CHECKLISTBOX:
                case ControlType.COMBOBOX:
					propertesbuilder = PropertiesJSONBuilderMap.getBuilder(meta.getColumnType());
					if(propertesbuilder != null) {
						propertesbuilder.load(ve, builder, json, metaForm, metaColumn, meta.getKey());
					}	
                	break;
                case ControlType.NUMBEREDITOR:
                	MetaNumberEditorProperties metanumber=(MetaNumberEditorProperties) metaColumn;
        			JSONHelper.writeToJSON(json,JSONConstants.COMPONENT_PROMPTTEXT, metanumber.getPromptText(),"" );
        			MetaNumberEditorProperties metaNum = (MetaNumberEditorProperties) metaColumn;
        			JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_DECPRECISION, metaNum.getPrecision(), -1);
        			JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_DECSCALE, metaNum.getScale(), -1);
        			JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_ROUNDINGMODE, metaNum.getRoundingMode(), RoundingMode.HALF_UP);
        			JSONHelper.writeToJSON(json, JSONConstants.NUMBEREDITOR_SHOWZERO, metaNum.isShowZero(), false);
        			break;
                case ControlType.TIMEPICKER:
                	MetaTimePickerProperties metaTimePicker = (MetaTimePickerProperties) metaColumn;
                	JSONHelper.writeToJSON(json, JSONConstants.TIMEPICKER_SECOND, metaTimePicker.isSecond(), false);
                	break;
		        case ControlType.TEXTAREA:
		        	MetaTextEditorProperties metaTextArea = (MetaTextAreaProperties)metaColumn;
					JSONHelper.writeToJSON(json, JSONConstants.TEXTEDITOR_MAXLENGTH, metaTextArea.getMaxLength(), 255);
		        	
    		}
	        
			if(script != null) {
				JSONHelper.writeToJSON(json, JSONConstants.COMMON_CLICKCONTENT, script.getContent().trim(), "");
			}
			JSONHelper.writeToJSON(metaListViewColumnh, JSONConstants.COMMON_DEFAULTVALUE, meta.getDefaultValue(), "");
			JSONHelper.writeToJSON(metaListViewColumnh, JSONConstants.COMMON_DEFAULTFORMULAVALUE, meta.getDefaultFormulaValue().trim(), "");
	}
	
	private JSONArray buildItems(String key, MetaStateItemCollection collection, IRootJSONBuilder<AbstractMetaObject> builder) throws Throwable{
		JSONArray array = new JSONArray();
		Iterator<MetaStateItem> it = collection.iterator();
		MetaStateItem item = null;
		while(it.hasNext()) {
			item = it.next();
			JSONObject o = new JSONObject();
			JSONHelper.writeToJSON(o, JSONConstants.STATEITEM_KEY, item.getKey());
			String text = builder.getString(GroupKeyTable.STR_ITEMS, key, "Item-"+item.getKey(), item.getText());
			JSONHelper.writeToJSON(o, JSONConstants.STATEITEM_TEXT, text);
			JSONHelper.writeToJSON(o, JSONConstants.STATEITEM_VALUE, item.getValue());
			JSONHelper.writeToJSON(o, JSONConstants.STATEITEM_ICON, item.getIcon());
			array.put(o);
		}
		return array;
	}

}
