package com.bokesoft.yes.mid.web.ui.load.control;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BaseComponentJSONBuilder;
import com.bokesoft.yigo.common.def.IconLocationType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.MetaRadioButton;
import com.bokesoft.yigo.tools.ve.VE;

public class RadioButtonJSONBuilder extends BaseComponentJSONBuilder<MetaRadioButton> {

	@Override
	public JSONObject getMetaJSON(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm, MetaRadioButton meta) throws Throwable {
		JSONObject metaJSON = super.getMetaJSON(ve, builder, metaForm, meta);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.RADIOBUTTON_GROUPKEY, meta.getGroupKey(), null);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.RADIOBUTTON_METAVALUE, meta.getSelectedValue(), null);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.RADIOBUTTON_ISGROUPHEAD, meta.isGroupHead(), false);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.COMMON_ICON, meta.getIcon(), "");
		JSONHelper.writeToJSON(metaJSON, JSONConstants.CHECKBOX_SELECTEDICON, meta.getSelectedIcon(), "");
		JSONHelper.writeToJSON(metaJSON, JSONConstants.CHECKBOX_ICONLOCATION, IconLocationType.toString(meta.getIconLocation()), IconLocationType.STR_LEFT);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.CHECKBOX_HIDEBUTTON, meta.getIsHideButton(), false);
		return metaJSON;
	}
	
}
