package com.bokesoft.yes.mid.web.ui.load.control;

import java.util.Iterator;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BaseComponentJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaPara;
import com.bokesoft.yigo.meta.common.MetaParas;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.map.MetaMapDraw;
import com.bokesoft.yigo.tools.ve.VE;

public class MapDrawJSONBuilder extends BaseComponentJSONBuilder<MetaMapDraw> {

	@Override
	public JSONObject getMetaJSON(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm, MetaMapDraw meta) throws Throwable {
		JSONObject metaJSON = super.getMetaJSON(ve, builder, metaForm, meta);
		metaJSON.put(JSONConstants.MAP_TYPE, meta.getType());
		metaJSON.put(JSONConstants.MAP_URL, meta.getURL());
		MetaPara metaPara = null;
		MetaParas metaParas = meta.getParas();
		JSONObject paras = new JSONObject();
		if (metaParas != null) {
			Iterator<MetaPara> itPara = metaParas.iterator();
			while (itPara.hasNext()) {
				metaPara = itPara.next();
				paras.put(metaPara.getKey(), metaPara.getValue());
			}
		}
		metaJSON.put(JSONConstants.MAP_PARAS, paras);
		return metaJSON;
	}
	
}