package com.bokesoft.yes.mid.web.ui.load.commondef;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.DictFilterType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFilter;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaFilterValue;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilter;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaItemFilterCollection;
import com.bokesoft.yigo.tools.ve.VE;

public class ItemFilterCollectionJSONBuilder extends AbstractJSONBuilder<MetaItemFilterCollection> {
	
	@Override
	public void load(VE ve,
			IRootJSONBuilder<AbstractMetaObject> builder,
			JSONObject json, MetaForm metaForm, MetaItemFilterCollection meta) throws Throwable {
		
		transDictFilters(json, meta);
		
	}
	
	private void transDictFilters(JSONObject itemFilterJons, MetaItemFilterCollection itemFilters) {
		if(itemFilters != null){
			for(MetaItemFilter itemFilter : itemFilters){	
				itemFilterJons.put(itemFilter.getItemKey(), transItemFilter(itemFilter));
			}
		}
	}

	private JSONArray transItemFilter(MetaItemFilter itemFilter) {
		JSONArray filters = new JSONArray();
		MetaFilter metaFilter = null;
		Iterator<MetaFilter> it = itemFilter.iterator();
		int i = 0;
		while (it.hasNext()) {
			metaFilter = it.next();
			filters.put(transFilter(metaFilter, i++));
		}
		return filters;
	}
	
	private JSONObject transFilter(MetaFilter metaFilter , int index){
		JSONObject filterJson = new JSONObject();
		filterJson.put(JSONConstants.DICT_COND, metaFilter.getCondition());
		filterJson.put(JSONConstants.DICT_DEPENDENCY, String.join(",", metaFilter.getDependedFields()));
		filterJson.put(JSONConstants.DICT_FILTERINDEX, index);
		JSONArray refValue = new JSONArray();
		JSONObject filterValueJson = null;
		int filterType = metaFilter.getType();
		for(MetaFilterValue fieldValue : metaFilter){
			filterValueJson = new JSONObject();
			filterValueJson.put(JSONConstants.COMMON_TYPE, fieldValue.getType());
			filterValueJson.put(JSONConstants.COMMON_DATATYPE, fieldValue.getDataType());
			if(filterType == DictFilterType.FieldValue){
				filterValueJson.put(JSONConstants.DICT_REFVAL, fieldValue.getRefValueKey());	
			}else if(filterType == DictFilterType.DataSet){
				filterValueJson.put(JSONConstants.DICT_REFVAL, fieldValue.getParaValue());	
			}else if(filterType == DictFilterType.Custom){
				filterValueJson.put(JSONConstants.DICT_REFVAL, fieldValue.getParaValue());	
			}
			refValue.put(filterValueJson);
		}
		filterJson.put(JSONConstants.DICT_FILTERVALS, refValue);
		return filterJson;
	}

}
