package com.bokesoft.yes.mid.web.service;

import java.util.HashMap;

import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.service.GeneralService;
import com.bokesoft.yes.mid.web.cmd.AutoPrintPDFCmd;
import com.bokesoft.yes.mid.web.cmd.BatchPrintPDFCmd;
import com.bokesoft.yes.mid.web.cmd.GetOutputPageCmd;
import com.bokesoft.yes.mid.web.cmd.PrintGridPDFCmd;
import com.bokesoft.yes.mid.web.cmd.PrintPDFCmd;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.service.IServiceProvider;

public class WebPrintService extends GeneralService<DefaultContext> {
	@Override
	public String getServiceName() {
		return "WebPrintService";
	}
	
	@Override
	public IServiceProvider<DefaultContext> newInstance() {
		return new WebPrintService();
	}

	@SuppressWarnings("unchecked")
	@Override
	public IServiceCmd<DefaultContext> getPrototype(DefaultContext context,
			String cmd) {
		return (IServiceCmd<DefaultContext>)WebPrintService.prototype.get(cmd);
	}

	private static HashMap<String, IServiceCmd<?>> prototype = null;
	static {
		WebPrintService.prototype = new HashMap<String, IServiceCmd<?>>();
		GeneralService.initPrototype(WebPrintService.prototype, new WebPrintService());
	}
	
	@Override
	protected Object[][] getCmdImplTable() {

		return new Object[][]{
				{ "PrintPDF", new PrintPDFCmd() },
				{ "BatchPrintPDF", new BatchPrintPDFCmd() },
				{ "AutoPrintPDF", new AutoPrintPDFCmd() },
				{ "PrintGridPDF", new PrintGridPDFCmd() },
				{ "GetOutputPage", new GetOutputPageCmd() }
		};
	}

	@Override
	protected IServiceCmd<DefaultContext> getDefaultImpl() {
		return null;
	}

}