package com.bokesoft.yes.mid.web.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.enhance.MetaEnhance;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class GetEnhanceCmd extends DefaultServiceCmd {
	private String projectKey = null;
	
	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		projectKey = TypeConvertor.toString(arguments.get("projectKey"));
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaEnhance enhance = metaFactory.getEnhance(projectKey);
		if( enhance != null ) {
			return UIJSONHandlerUtil.build(enhance, new SolutionSerializeContext(context.getVE()));
		}
		return null;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetEnhanceCmd();
	}

	@Override
	public String getCmd() {
		return "GetEnhance";
	}

}
