package com.bokesoft.yes.mid.web.ui.load.viewcollection;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDefCollection;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDefCollection;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaGridLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSpan;
import com.bokesoft.yigo.tools.ve.VE;

public class GridLayoutJSONBuilder extends AbstractJSONBuilder<MetaGridLayout> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaGridLayout meta) throws Throwable {

		json.put(JSONConstants.COMMON_TYPE, LayoutType.toString(meta.getLayoutType()));
		// 载入行定义
		MetaRowDefCollection rowDefCollection = meta.getRowDefCollection();
		if (rowDefCollection != null) {
			JSONObject rowDefCollectionJSON = builder.build(ve, builder, metaForm, rowDefCollection);
			json.put("rowDefCollection", rowDefCollectionJSON);
		}

		// 载入列定义
		MetaColumnDefCollection columnDefCollection = meta.getColumnDefCollection();
		if (columnDefCollection != null) {
			JSONObject columnDefCollectionJSON = builder.build(ve, builder, metaForm, columnDefCollection);
			json.put("columnDefCollection", columnDefCollectionJSON);
		}

		JSONArray itemArray = new JSONArray();
		Iterator<MetaLayoutSpan> it = meta.iterator();
		while(it.hasNext()){
			MetaLayoutSpan metaLayoutSpan = it.next();
			JSONObject layoutSpanObj = new JSONObject();
			JSONHelper.writeToJSON(layoutSpanObj, JSONConstants.COMMON_KEY, metaLayoutSpan.getKey(), "");
			JSONHelper.writeToJSON(layoutSpanObj, JSONConstants.LAYOUTSPAN_ITEM_X, metaLayoutSpan.getX(), -1);
			JSONHelper.writeToJSON(layoutSpanObj, JSONConstants.LAYOUTSPAN_ITEM_XSPAN, metaLayoutSpan.getXSpan(), -1);
			JSONHelper.writeToJSON(layoutSpanObj, JSONConstants.LAYOUTSPAN_ITEM_Y, metaLayoutSpan.getY(), -1);
			JSONHelper.writeToJSON(layoutSpanObj, JSONConstants.LAYOUTSPAN_ITEM_YSPAN, metaLayoutSpan.getYSpan(), -1);
			itemArray.put(layoutSpanObj);
		}
		
		json.put("layoutSpans", itemArray);
	}
}
