package com.bokesoft.yes.mid.web.ui.load.viewcollection;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFlexFlowLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutFlowIndex;
import com.bokesoft.yigo.tools.ve.VE;

public class FlexFlowLayoutJSONBuilder extends AbstractJSONBuilder<MetaFlexFlowLayout> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaFlexFlowLayout meta) throws Throwable {

		json.put(JSONConstants.COMMON_TYPE, LayoutType.toString(meta.getLayoutType()));
		JSONArray itemArray = new JSONArray();
		Iterator<MetaLayoutFlowIndex> it = meta.iterator();
		while (it.hasNext()) {
			MetaLayoutFlowIndex metaLayoutFlowIndex = it.next();
			JSONObject layoutSpanObj = new JSONObject();
			JSONHelper.writeToJSON(layoutSpanObj, JSONConstants.COMMON_KEY, metaLayoutFlowIndex.getKey(), "");
			DefSize height = metaLayoutFlowIndex.getHeight();
			JSONHelper.writeToJSON(layoutSpanObj, JSONConstants.COMMON_HEIGHT, height == null ? "" : height.toString(), "");
			itemArray.put(layoutSpanObj);
		}

		json.put(JSONConstants.COMMON_ITEMS, itemArray);
	}

}
