package com.bokesoft.yes.mid.web.ui.load.viewcollection;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.DirectionType;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaBorderLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutDirection;
import com.bokesoft.yigo.tools.ve.VE;

public class BorderLayoutJSONBuilder extends AbstractJSONBuilder<MetaBorderLayout> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaBorderLayout meta) throws Throwable {
		json.put(JSONConstants.COMMON_TYPE, LayoutType.toString(meta.getLayoutType()));
		JSONArray itemArray = new JSONArray();
		Iterator<MetaLayoutDirection> it = meta.iterator();
		while (it.hasNext()) {
			MetaLayoutDirection metaLayoutDirection = it.next();
			JSONObject directionObj = new JSONObject();
			JSONHelper.writeToJSON(directionObj, JSONConstants.COMMON_KEY, metaLayoutDirection.getKey(), "");
			JSONHelper.writeToJSON(directionObj, "", DirectionType.toString(metaLayoutDirection.getValue()), "");
			itemArray.put(directionObj);
		}
		json.put(JSONConstants.COMMON_ITEMS, itemArray);
	}

}
