package com.bokesoft.yes.mid.web.ui.load.tableview;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BaseComponentJSONBuilder;
import com.bokesoft.yigo.common.def.PageLoadType;
import com.bokesoft.yigo.common.def.TableRowStyle;
import com.bokesoft.yigo.common.def.TableViewRowType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRowAction;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaRowActionCollection;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRow;
import com.bokesoft.yigo.tools.ve.VE;

public class TableRowJSONBuilder extends BaseComponentJSONBuilder<MetaTableRow> {
	public static String TABLEVIEW_ROOT = "root";
	public static String TABLEVIEW_ROWTYPE = "rowType";
	public static String TABLEVIEW_TABLEKEY = "tableKey";
	public static String TABLEVIEW_GROUPCOLUMNKEYS = "groupColumnKeys";
	public static String TABLEVIEW_STYLE = "style";
	public static String TABLEVIEW_COLUMNCOUNT = "columnCount";
	public static String TABLEVIEW_INDICATOR = "indictator";
	public static String TABLEVIEW_SEPARATORSTYLE = "separatorStyle";
	public static String TABLEVIEW_SEPARATORCOLOR = "separatorColor";
	public static String TABLEVIEW_SEPARATOROFFSET = "separatorOffset";
	public static String TABLEVIEW_SELECTCOLOR = "selectColor";
	public static String TABLEVIEW_HIGHLIGHTCOLOR = "highLightColor";
	public static String TABLEVIEW_SHOWFIRSTMARGIN = "showFirstMargin";

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaTableRow meta) throws Throwable {
		super.load(ve, builder, json, metaForm, meta);

		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TAGNAME, meta.getTagName().toLowerCase(), "");
		JSONHelper.writeToJSON(json, TABLEVIEW_ROWTYPE, TableViewRowType.toString(meta.getRowType()), TableViewRowType.STR_Fix);
		JSONHelper.writeToJSON(json, TABLEVIEW_TABLEKEY, meta.getTableKey(), "");
		JSONHelper.writeToJSON(json, TABLEVIEW_STYLE, TableRowStyle.toString(meta.getStyle()), TableRowStyle.STR_List);
		JSONHelper.writeToJSON(json, TABLEVIEW_COLUMNCOUNT, meta.getColumnCount(), 3);
		
		json.put(TABLEVIEW_ROOT, builder.build(ve, builder, metaForm, meta.getRoot()));

		MetaBaseScript click = (MetaBaseScript) meta.getRowClick();
		if (click != null) {
			json.put(JSONConstants.Event_RowClick, click.getContent().trim());
		}

		MetaBaseScript dbClick = meta.getRowDblClick();
		if (dbClick != null) {
			json.put(JSONConstants.Event_RowDblClick, dbClick.getContent().trim());
		}

		MetaBaseScript rowChange = meta.getFocusRowChanged();
		if (rowChange != null) {
			json.put(JSONConstants.Event_FocusRowChanged, rowChange.getContent().trim());
		}
		MetaBaseScript onCollapse = meta.getOnCollapse();
		if (onCollapse != null) {
			json.put(JSONConstants.Event_OnCollapse, onCollapse.getContent().trim());
		}
		MetaBaseScript onExpand = meta.getOnExpand();
		if (onExpand != null) {
			json.put(JSONConstants.Event_OnExpand, onExpand.getContent().trim());
		}

		JSONArray actions = new JSONArray();
		MetaRowActionCollection collection = meta.getActionCollection();
		if (collection != null) {
			for (int i = 0; i < meta.getActionCollection().size(); i++) {
				MetaRowAction metaRowAction = meta.getActionCollection().get(i);
				JSONObject actionObject = new JSONObject();
				actionObject.put(JSONConstants.COMMON_KEY, metaRowAction.getKey());
				actionObject.put(JSONConstants.COMMON_CAPTION, metaRowAction.getCaption());
				actionObject.put(JSONConstants.LISTVIEW_ROW_ACTION_CONTENT, metaRowAction.getContent());
				actions.put(actionObject);
			}
			json.put(JSONConstants.LISTVIEW_ROW_ACTION_COLLECTION, actions);
		}

		JSONHelper.writeToJSON(json, TABLEVIEW_GROUPCOLUMNKEYS, meta.getGroupColumnKeys(), "");
		JSONHelper.writeToJSON(json, TABLEVIEW_SEPARATORSTYLE, meta.getSeparatorStyle(), "");
		JSONHelper.writeToJSON(json, TABLEVIEW_SEPARATORCOLOR, meta.getSeparatorColor(), "");
		JSONHelper.writeToJSON(json, TABLEVIEW_SEPARATOROFFSET, meta.getSeparatorOffset().toString(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TOPMARGIN, meta.getTopMargin(), "");
		JSONHelper.writeToJSON(json, TABLEVIEW_SHOWFIRSTMARGIN, meta.isShowFirstMargin(), false);
		JSONHelper.writeToJSON(json, TABLEVIEW_SELECTCOLOR, meta.getSelectColor(), "");
		JSONHelper.writeToJSON(json, TABLEVIEW_HIGHLIGHTCOLOR, meta.getHighlightColor(), "");
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_BACKCOLOR, meta.getBackColor(), "");

		JSONHelper.writeToJSON(json, "indicator", meta.isIndicator(), false);
		JSONHelper.writeToJSON(json, "hoverHead", meta.isHoverHead(), false);
		JSONHelper.writeToJSON(json, "indicatorKey", meta.getIndicatorKey(), "");
		JSONHelper.writeToJSON(json, "groupCollapse", meta.isGroupCollapse(), false);
		JSONHelper.writeToJSON(json, "promptImage", meta.getPromptImage(), "");
		JSONHelper.writeToJSON(json, "promptRowCount", meta.getPromptRowCount(), MetaTableRow.DEFAULT_PROMPT_ROW_COUNT);
		JSONHelper.writeToJSON(json, "pageRowCount", meta.getPageRowCount(), 50);
		JSONHelper.writeToJSON(json, "pageLoadType", PageLoadType.toString(meta.getPageLoadType()), PageLoadType.STR_NONE);
	}
}
