package com.bokesoft.yes.mid.web.ui.load.panel.flexboxpaneljsonbuilder;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BasePanelJSONBuilder;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.FlexBoxPanel.MetaFlexBoxPanel;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFlexBox;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutItem;
import com.bokesoft.yigo.tools.ve.VE;

public class FlexBoxPanelJSONBuilder extends BasePanelJSONBuilder<MetaFlexBoxPanel> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaFlexBoxPanel meta) throws Throwable {
		super.load(ve, builder, json, metaForm, meta);

		json.put(JSONConstants.FLEXBOXPANEL_REPEATCOUNT, meta.getRepeatCount());
		json.put(JSONConstants.BASEPANEL_LAYOUT, LayoutType.STR_LAYOUT_FLEXBOX);
		MetaFlexBox layoutImpl = meta.newLayout();
		Iterator<MetaLayoutItem> it = layoutImpl.iterator();
		MetaLayoutItem item = null;
		MetaComponent metaComponent = null;
		JSONArray items = new JSONArray();
		JSONObject childJSON = null;
		while (it.hasNext()) {
			item = it.next();
			metaComponent = meta.getComponent(item.getKey());
			childJSON = builder.build(ve, builder, metaForm, metaComponent);
			items.put(childJSON);
		}
		json.put(JSONConstants.COMMON_ITEMS, items);
	}
}
