package com.bokesoft.yes.mid.web.ui.load.panel;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BasePanelJSONBuilder;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.MetaWizardPanel;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutWizardItem;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaWizardLayout;
import com.bokesoft.yigo.tools.ve.VE;

public class WizardPanelJSONBuilder extends BasePanelJSONBuilder<MetaWizardPanel> {

	@Override
	public void load(VE ve,
			IRootJSONBuilder<AbstractMetaObject> builder,
			JSONObject json, MetaForm metaForm, MetaWizardPanel meta)
			throws Throwable {
		super.load(ve, builder, json, metaForm, meta);
		json.put(JSONConstants.BASEPANEL_LAYOUT, LayoutType.STR_LAYOUT_WIZARD);
		MetaWizardLayout layoutImpl = meta.newLayout();
		Iterator<MetaLayoutWizardItem> it = layoutImpl.iterator();
		MetaLayoutWizardItem metaWizardItem = null;
		MetaComponent metaComponent = null;
		JSONArray items = new JSONArray();
		JSONObject childJSON = null;
		while (it.hasNext()) {
			metaWizardItem = it.next();
			metaComponent = meta.getComponent(metaWizardItem.getKey());
			childJSON = builder.build(ve, builder, metaForm, metaComponent);
			items.put(childJSON);
		}
		json.put(JSONConstants.COMMON_ITEMS, items);
		MetaBaseScript finish = meta.getFinish();
		if( finish != null ) {
			json.put(JSONConstants.WIZARDPANEL_FINISH, finish.getContent().trim());
		}
	}	
}
