package com.bokesoft.yes.mid.web.ui.load.panel;

import java.util.Iterator;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.BasePanelJSONBuilder;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.LayoutType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.panel.tablepanel.MetaFluidTableLayoutPanel;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaFluidTableLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutColumn;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutColumnCollection;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutRowIndex;
import com.bokesoft.yigo.tools.ve.VE;

public class FluidTableLayoutPanelJSONBuilder extends BasePanelJSONBuilder<MetaFluidTableLayoutPanel> {

	@Override
	public void load(VE ve,
			IRootJSONBuilder<AbstractMetaObject> builder,
			JSONObject json, MetaForm metaForm, MetaFluidTableLayoutPanel meta)
			throws Throwable {
		super.load(ve, builder, json, metaForm, meta);
		json.put(JSONConstants.BASEPANEL_LAYOUT, LayoutType.STR_LAYOUT_FLUIDTABLE);
		
		
		MetaFluidTableLayout metaFluidTableLayout = meta.newLayout();
		MetaLayoutColumnCollection metaLayoutColumnCollection = metaFluidTableLayout.getColumnCollection();
		
		JSONArray widths = new JSONArray();
		// 循环所有的列，向网格布局面板中加入列宽定义
		MetaLayoutColumn metaColumnDef = null;
		if (metaLayoutColumnCollection != null) {
			Iterator<MetaLayoutColumn> itColumnDef = metaLayoutColumnCollection.iterator();
			while (itColumnDef.hasNext()) {
				metaColumnDef = itColumnDef.next();
				DefSize width = metaColumnDef.getWidth();
				if (width != null) {
					if (width.getSizeType() == DefSize.Fix) {
						widths.put(width.getSize());
					} else if (width.getSizeType() == DefSize.Ratio) {
						widths.put(width.toString());
					} else if (width.getSizeType() == DefSize.Pref) {
						widths.put(DefSize.STR_Pref);
					}
				}
			}
		}
		json.put(JSONConstants.FLUIDTABLELAYOUTPANEL_WIDTHS, widths);
		JSONHelper.writeToJSON(json, JSONConstants.FLUIDTABLELAYOUTPANEL_REPEATCOUNT, meta.getRepeatCount(), 1);
		JSONHelper.writeToJSON(json, JSONConstants.FLUIDTABLELAYOUTPANEL_REPEATGAP, meta.getRepeatGap(), 0);
		JSONHelper.writeToJSON(json, JSONConstants.FLUIDTABLELAYOUTPANEL_ROWGAP, meta.getRowGap(), 0);
		JSONHelper.writeToJSON(json, JSONConstants.FLUIDTABLELAYOUTPANEL_COLUMNGAP, meta.getColumnGap(), 0);
		JSONHelper.writeToJSON(json, JSONConstants.FLUIDTABLELAYOUTPANEL_ROWHEIGHT, meta.getRowHeight(), 0);
		
		Iterator<MetaLayoutRowIndex> itRowIndex = metaFluidTableLayout.iterator();
		MetaLayoutRowIndex metaLayoutRowIndex = null;
		JSONArray items = new JSONArray();
		JSONObject childJSON = null;
		while ( itRowIndex.hasNext() ) {
			metaLayoutRowIndex = itRowIndex.next();
			String key = metaLayoutRowIndex.getKey();
			MetaComponent metaComponent = meta.getComponent(key);
			childJSON = builder.build(ve, builder, metaForm, metaComponent);
			String buddyKey = metaComponent.getBuddyKey();
			if ( buddyKey != null && !buddyKey.isEmpty() ) {
				metaComponent = meta.getComponent(buddyKey);
				JSONObject component = builder.build(ve, builder, metaForm, metaComponent);
				items.put(component);
			}
			childJSON.put(JSONConstants.COMMON_BUDDYKEY, buddyKey);
			items.put(childJSON);
		}
		json.put(JSONConstants.COMMON_ITEMS, items);
	}
}
