package com.bokesoft.yes.mid.web.ui.load.navigationbar;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.AbstractJSONBuilder;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaNavigationBar;
import com.bokesoft.yigo.meta.form.MetaNavigationBarItem;
import com.bokesoft.yigo.tools.ve.VE;

public class NavigationBarJSONBuilder extends AbstractJSONBuilder<MetaNavigationBar> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaNavigationBar meta) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONBAR_TITLE, meta.getTitle(), "");
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATION_BACKCOLOR, meta.getBackColor(), "");
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATION_FORECOLOR, meta.getForeColor(), "");
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATION_BACKIMAGE, meta.getBackImage(), "");
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONBAR_HASLEFTBUTTON, meta.getHasLeftButton(), "");
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONBAR_HASRIGHTBUTTON, meta.getHasRightButton(), "");
		JSONHelper.writeToJSON(json, JSONConstants.NAVIGATIONBAR_ELEVATION, TypeConvertor.toString(meta.getElevation()), "");
		if (meta.getLeftButton() != null) {
			JSONObject leftBtnObj = new JSONObject();
			JSONHelper.writeToJSON(leftBtnObj, JSONConstants.COMMON_ICON, meta.getLeftButton().getIcon(), "");
			JSONHelper.writeToJSON(leftBtnObj, JSONConstants.NAVIGATIONBAR_BUTTON_CONTENT,
					meta.getLeftButton().getContent(), "");
			json.put(JSONConstants.NAVIGATIONBAR_LEFTBUTTON, leftBtnObj);
		}
		if (meta.getRightButton() != null) {
			JSONObject rightBtnObj = new JSONObject();
			JSONHelper.writeToJSON(rightBtnObj, JSONConstants.COMMON_ICON, meta.getRightButton().getIcon(), "");
			JSONHelper.writeToJSON(rightBtnObj, JSONConstants.NAVIGATIONBAR_BUTTON_CONTENT,
					meta.getRightButton().getContent(), "");
			json.put(JSONConstants.NAVIGATIONBAR_RIGHTBUTTON, rightBtnObj);
		}
		if (meta.size() > 0) {
			JSONArray itemArray = new JSONArray();
			for (int i = 0; i < meta.size(); i++) {
				MetaNavigationBarItem item = meta.get(i);
				JSONObject itemObj = builder.build(ve, builder, metaForm, item);
				itemArray.put(itemObj);
			}
			json.put(JSONConstants.COMMON_ITEMS, itemArray);
		}
	}

}
