package com.bokesoft.yes.mid.web.ui.load.control.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaUploadButtonProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class UploadButtonPropertiesJSONBuilder extends PropertiesJSONBuilder<MetaUploadButtonProperties>{

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaUploadButtonProperties meta, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.UPLOADBUTTON_MAXSIZE, meta.getMaxSize(), -1);
		JSONHelper.writeToJSON(json, JSONConstants.UPLOADBUTTON_ALLOWEDTYPES, meta.getAllowedTypes(), "");
		JSONHelper.writeToJSON(json, JSONConstants.UPLOADBUTTON_DELETEOLD, meta.isDeleteOld(), false);
		JSONHelper.writeToJSON(json, JSONConstants.UPLOADBUTTON_ISMULTIFILE, meta.isMultiFile(), false);
		JSONHelper.writeToJSON(json, JSONConstants.UPLOADBUTTON_POSTPROCESS, meta.getPostProcess(), "");
		
		MetaBaseScript finishEvent = meta.getFinishEvent();
		if(finishEvent != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_FinishedEvent, finishEvent.getContent(), "");
			
		}
	}

}
