package com.bokesoft.yes.mid.web.ui.load.control.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSliderProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class SliderPropertiesJSONBuilder extends PropertiesJSONBuilder<MetaSliderProperties>{

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaSliderProperties meta, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.SLIDER_MAXPOS, meta.getMaxPos(), 100);
		JSONHelper.writeToJSON(json, JSONConstants.SLIDER_MINPOS, meta.getMinPos(), 0);
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSBAR_STEPVALUE, meta.getStepValue(), 0);
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSBAR_BARCOLOR, meta.getBarColor(), "");
		JSONHelper.writeToJSON(json, JSONConstants.PROGRESSBAR_PROGRESSCOLOR, meta.getProgressColor(), "");
	}

}
