package com.bokesoft.yes.mid.web.ui.load.control.properties;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.common.def.LabelLineBreakType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaLabelProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class LabelPropertiesJSONBuilder extends PropertiesJSONBuilder<MetaLabelProperties> {

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm, MetaLabelProperties meta, String key) throws Throwable {
		JSONHelper.writeToJSON(json, JSONConstants.LABEL_ICON, meta.getIcon(), "");
		JSONHelper.writeToJSON(json, JSONConstants.LABEL_SINGLELINE, meta.isSingleLine(), true);
		JSONHelper.writeToJSON(json, JSONConstants.LABEL_LINEBREKTYPE, 
				LabelLineBreakType.toString(meta.getLineBreakMode()), LabelLineBreakType.STR_ENDHIDE);
		JSONHelper.writeToJSON(json, JSONConstants.LABEL_MAXLINES, meta.getMaxLines(), -1);
		JSONHelper.writeToJSON(json, JSONConstants.LABEL_EXPANDCAPTION, meta.getExpandCaption(), "");
	}
}
