package com.bokesoft.yes.mid.web.ui.load.control.properties;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.PropertiesJSONBuilder;
import com.bokesoft.yigo.common.def.ImageScaleType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.common.MetaBaseScript;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.MetaImageListItem;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaImageListProperties;
import com.bokesoft.yigo.tools.ve.VE;

public class ImageListPropertiesJSONBuilder extends PropertiesJSONBuilder<MetaImageListProperties> {

	@Override
	protected void loadImpl(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaImageListProperties meta, String key) throws Throwable {
//		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_STRETCH, meta.isStretch(), false);
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_IMAGESCALETYPE,
				ImageScaleType.toString(meta.getImageScaleType()), "");
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_PROMPTIMAGE, meta.getPromptImage(), "");
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_RADIUS, meta.getRadius(), -1);
		JSONHelper.writeToJSON(json, JSONConstants.IMAGE_MASKIMAGE, meta.getMaskImage(), "");
		
		JSONArray itemArray = new JSONArray();
		for(int i=0;i<meta.size();i++){
			MetaImageListItem metaItem = meta.get(i);
			JSONObject itemObj = new JSONObject();
			JSONHelper.writeToJSON(itemObj, JSONConstants.COMMON_VALUE, metaItem.getValue(), "");
			JSONHelper.writeToJSON(itemObj, JSONConstants.IMAGE_IMAGE, metaItem.getImage(), "");
			itemArray.put(itemObj);
		}
		
		json.put(JSONConstants.COMMON_ITEMS, itemArray);

		MetaBaseScript onClick = meta.getOnClick();
		if(onClick != null){
			JSONHelper.writeToJSON(json, JSONConstants.Event_OnClick, onClick.getContent(), "");
		}
	}

}
