package com.bokesoft.yes.mid.web.ui.load.control.listview.extend;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yes.mid.web.ui.load.control.editview.EditViewJSONBuilder;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaTiledList;
import com.bokesoft.yigo.tools.ve.VE;

public class TiledListJSONBuilder extends EditViewJSONBuilder {
	@Override
	public JSONObject getMetaJSON(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, MetaForm metaForm,
			MetaEditView meta) throws Throwable {
		MetaTiledList metaTiledList = (MetaTiledList)meta;
		JSONObject metaJSON = super.getMetaJSON(ve, builder, metaForm, meta);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.TILEDLIST_COUNT, metaTiledList.getCount(), MetaTiledList.TILEDLIST_DEFAULT_COUNT);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.TILEDLIST_ROWGAP, metaTiledList.getRowGap(), 0);
		JSONHelper.writeToJSON(metaJSON, JSONConstants.TILEDLIST_CELLGAP, metaTiledList.getCellGap(), 0);
		return metaJSON;
	}
}
