package com.bokesoft.yes.mid.web.ui.load;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.mid.web.ui.IRootJSONBuilder;
import com.bokesoft.yigo.common.def.ContainerStyle;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.container.MetaContainer;
import com.bokesoft.yigo.tools.ve.VE;

public class ContainerJSONBuilder extends BaseComponentJSONBuilder<MetaContainer> {

	@Override
	public void load(VE ve, IRootJSONBuilder<AbstractMetaObject> builder, JSONObject json, MetaForm metaForm,
			MetaContainer meta) throws Throwable {
		super.load(ve, builder, json, metaForm, meta);
		String tagName = "";
		switch (meta.getStyle()) {
		case ContainerStyle.Tab:
			tagName = "TabContainer";
			break;
		case ContainerStyle.Stack:
			tagName = "StackContainer";
			break;
		}
		JSONHelper.writeToJSON(json, JSONConstants.COMMON_TAGNAME, tagName.toLowerCase(), "");
		JSONHelper.writeToJSON(json, JSONConstants.CONTAINER_DEFAULT, meta.isDefault(), false);
		JSONHelper.writeToJSON(json, JSONConstants.CONTAINER_MERGEOPERATION, meta.isMergeOperation(), false);
		JSONHelper.writeToJSON(json, JSONConstants.CONTAINER_DEFAULTFORMKEY, meta.getDefaultFormKey(), "");
		JSONHelper.writeToJSON(json, JSONConstants.CONTAINER_FORMULAFORMKEY, meta.getFormulaFormKey(), "");

		if (meta.getStyle() == ContainerStyle.Tab) {
			JSONObject metaTabGroup = builder.build(ve, builder, metaForm, meta.getTabGroup());
			json.put(JSONConstants.CONTAINER_TABGROUP, metaTabGroup);
		}
	}

}
