//package com.bokesoft.yes.mid.web.cmd;
//
//import com.bokesoft.yes.datamap.calculate.MapData;
//import com.bokesoft.yes.datamap.calculate.MapValueResult;
//import com.bokesoft.yes.datamap.document.src.SrcDocument;
//import com.bokesoft.yes.datamap.document.tgt.TgtDocument;
//import com.bokesoft.yes.datamap.exception.MidDataMapException;
//import com.bokesoft.yes.datamap.i18n.StringTable;
//import com.bokesoft.yes.datamap.util.DataMapI18NUtil;
//import com.bokesoft.yes.log.LogSvr;
//import com.bokesoft.yes.struct.document.IFormulaProxy;
//import com.bokesoft.yes.tools.util.ReflectHelper;
//import com.bokesoft.yigo.meta.datamap.MetaMap;
//import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
//import com.bokesoft.yigo.meta.factory.IMetaFactory;
//import com.bokesoft.yigo.mid.base.DefaultContext;
//import com.bokesoft.yigo.mid.base.IServiceContext;
//import com.bokesoft.yigo.mid.service.IServiceProcess;
//import com.bokesoft.yigo.parser.IEval;
//import com.bokesoft.yigo.struct.document.Document;
//import com.bokesoft.yigo.tools.document.DocumentUtil;
//import com.bokesoft.yigo.tools.ve.VE;
//
///**
// * 无模型web的映射计算代理类
// * 
// * @author 刘翔翔
// *
// */
//public class WebPureMapProxy {
//
//	/** 数据源 */
//	private Document srcDoc = null;
//	/** 映射的KEY */
//	private String mapKey = null;
//	/** 映射的结果 */
//	private Document tgtDoc = null;
//
//	/**
//	 * 映射计算代理类的构造器
//	 * 
//	 * @param srcDoc
//	 *            数据源
//	 * @param mapKey
//	 *            映射的KEY
//	 */
//	public WebPureMapProxy(Document srcDoc, String mapKey) {
//		this.srcDoc = srcDoc;
//		this.mapKey = mapKey;
//	}
//
//	/**
//	 * 映射计算代理类的构造器
//	 * 
//	 * @param srcDoc
//	 *            数据源
//	 * @param mapKey
//	 *            映射的KEY
//	 * @param tgtDoc
//	 *            已有的数据作为映射目标（主要用于上引）
//	 */
//	public WebPureMapProxy(Document srcDoc, String mapKey, Document tgtDoc) {
//		this.srcDoc = srcDoc;
//		this.mapKey = mapKey;
//		this.tgtDoc = tgtDoc;
//	}
//
//	/**
//	 * 执行数据映射
//	 * 
//	 * @param ve
//	 *            外部环境
//	 * @param eval
//	 *            脚本解析器
//	 * @return 映射的结果
//	 * @throws Throwable
//	 */
//	public Document mapDoc(DefaultContext context, IEval<?> eval, IFormulaProxy proxy) throws Throwable {
//		VE ve = context.getVE();
//		IMetaFactory factory = ve.getMetaFactory();
//		MetaMap metaMap = factory.getDataMap(mapKey);
//
//		WebPureHelper helper = new WebPureHelper(context, srcDoc, mapKey, ve);
//		SrcDocument srcDocument = helper.createSrcDocument();
//		MapValueResult result = helper.getMapValueResult();
//
//		MapData md = new MapData(srcDocument, mapKey, factory);
//		if (md.prePrecess(eval, proxy, result)) {
//			if (tgtDoc == null) {
//				String tgtDataObjectKey = factory.getDataMap(mapKey).getTgtDataObjectKey();
//				MetaDataObject metaDataObject = factory.getDataObject(tgtDataObjectKey);
//				tgtDoc = DocumentUtil.newDocument(metaDataObject);
//				tgtDoc.setNew();
//			}
//			TgtDocument tgtDocument = new TgtDocument(tgtDoc, true);
//			md.doMap(tgtDocument);
//
//			// 下推后处理事件
//			DefaultContext targetContext = new DefaultContext(context);
//			targetContext.setDocument(tgtDocument.getDoc());
//			String postProcess = (metaMap.getPostProcess() != null ? metaMap.getPostProcess().getContent() : "");
//			if (postProcess != null && !postProcess.isEmpty()) {
//				Long now = System.currentTimeMillis();
//
//				@SuppressWarnings("unchecked")
//				IServiceProcess<IServiceContext> process = (IServiceProcess<IServiceContext>) ReflectHelper.newInstance(context.getVE(), postProcess);
//				if (process != null) {
//					process.process(targetContext);
//				}
//				LogSvr.getInstance().info("MapPostProcess:" + (System.currentTimeMillis() - now));
//				
//			}
//		} else {
//			String message = DataMapI18NUtil.getStringWithoutArgs(metaMap, ve, mapKey, StringTable.NoMapData);
//			throw new MidDataMapException(MidDataMapException.NO_MAP_DATA, message);
//		}
//		return tgtDoc;
//	}
//}
