package com.bokesoft.yes.mid.web.cmd;

import org.json.JSONArray;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.meta.json.DefaultSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.tools.ve.VE;

public class GetStatusCollectionCmd extends DefaultServiceCmd {

	private String formKey = "";
	
	@Override
	public void dealArguments(DefaultContext context,
			StringHashMap<Object> arguments) throws Throwable {
		formKey = (String) arguments.get("formKey");
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		VE ve = context.getVE();
		IMetaFactory metaFactory = ve.getMetaFactory();
		
		MetaDataObject dataObject = null;
		
		MetaForm metaForm = metaFactory.getMetaForm(formKey);
		if( metaForm != null ){
			MetaDataSource dataSource = metaForm.getDataSource();
			if( dataSource != null ) {
				dataObject = dataSource.getDataObject();				
			}
		}

		MetaStatusCollection statusCollection = MetaUtil.getStatusCollection(metaFactory,dataObject);
		
		JSONArray itemsArry = null;
		if (statusCollection != null) {
			itemsArry = UIJSONHandlerUtil.buildKeyCollection(new DefaultSerializeContext(metaForm, ve), statusCollection);
		}
		
		return itemsArry;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetStatusCollectionCmd();
	}

	@Override
	public String getCmd() {
		return "GetStatusCollection";
	}

	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}

