package com.bokesoft.yes.mid.web.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.solution.MetaSolution;
import com.bokesoft.yigo.meta.solution.MetaStartItem;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class GetStartItemCmd extends DefaultServiceCmd {
	
	private String platform = "";

	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		if(arguments.containsKey("platform")){
			platform = TypeConvertor.toString(arguments.get("platform"));
		}
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		MetaSolution metaSolution = context.getVE().getMetaFactory().getSolution();
		SolutionSerializeContext ctx = new SolutionSerializeContext(context.getVE());
		if(metaSolution.getStartItemCollection() != null){
			for(int i=0;i<metaSolution.getStartItemCollection().size();i++){
				MetaStartItem item = metaSolution.getStartItemCollection().get(i);
				if(item.getPlatform().toLowerCase().contains("all")||
						item.getPlatform().toLowerCase().contains("mobile")||
						item.getPlatform().toLowerCase().contains(platform.toLowerCase())){
					return UIJSONHandlerUtil.build(item, ctx);
				} 
			}
		}
		return null;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetStartItemCmd();
	}

	@Override
	public String getCmd() {
		return "GetStartItem";
	}

}
