package com.bokesoft.yes.mid.web.cmd;

import org.json.JSONArray;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.meta.json.SolutionSerializeContext;
import com.bokesoft.yes.meta.json.util.UIJSONHandlerUtil;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class GetMacroCollectionCmd extends DefaultServiceCmd {

	private String projectKey = null;

	@Override
	public void dealArguments(DefaultContext context,
			StringHashMap<Object> arguments) throws Throwable {
		projectKey = TypeConvertor.toString(arguments.get("projectKey"));
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaMacroCollection macroCollection = null;
		
		MetaCommonDef metaCommonDef = metaFactory.getCommonDef(projectKey);
		
		if (metaCommonDef != null) {
			macroCollection = metaCommonDef.getMacroCollection();
		}

		if(metaCommonDef == null){
			metaCommonDef = metaFactory.getSolutionCommondDef(projectKey);
			if(metaCommonDef != null){
				macroCollection = metaCommonDef.getMacroCollection();
			}
		}
		
		if(metaCommonDef == null){
			metaCommonDef = metaFactory.getCommonDef("");
			if(metaCommonDef != null){
				macroCollection = metaCommonDef.getMacroCollection();
			}
		}

		JSONArray array = null;
		if( macroCollection != null ) {
			array = UIJSONHandlerUtil.buildKeyCollection(new SolutionSerializeContext(context.getVE()), macroCollection);
		}
		
		return array;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetMacroCollectionCmd();
	}

	@Override
	public String getCmd() {
		return "GetMacroCollection";
	}
	
}
