package com.bokesoft.yes.mid.web.cmd;

import org.json.JSONObject;

import com.bokesoft.yes.common.json.JSONConstants;
import com.bokesoft.yes.common.json.JSONHelper;
import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.base.MidVEHost;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yes.mid.web.ui.WebJSONUIBuilder;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.web.util.ExtensionUtil;
import com.bokesoft.yigo.mid.web.util.IExtensionProvider;

public class GetFormVersionCmd extends DefaultServiceCmd {
	
	private String formKey = null;
	private Integer version = -1;
	
	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		formKey = TypeConvertor.toString(arguments.get("formKey"));
		Object versionArg = arguments.get("version");
		version = versionArg == null ? null : TypeConvertor.toInteger(versionArg);
	
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		MetaForm metaForm = context.getVE().getMetaFactory().getMetaForm(formKey);
		if(version == null || version == metaForm.getVersion()){
			return metaForm.getVersion();
		}else{
			MidVEHost veHost = new MidVEHost(context);
			veHost.setVE(context.getVE());
			
			WebJSONUIBuilder builder = new WebJSONUIBuilder();
			builder.setVEHost(veHost);
			builder.setMetaForm(metaForm);
			JSONObject formJson = builder.build();

			//前台扩展表单合并处理
			IExtensionProvider provider = ExtensionUtil.newProvider();
			if(provider != null){
				MetaForm extForm = provider.getExtMetaForm(context, metaForm);
				if (extForm != null) {
					WebJSONUIBuilder extFormBuilder = new WebJSONUIBuilder();
					extFormBuilder.setVEHost(veHost);
					extFormBuilder.setMetaForm(extForm);
					JSONObject extFormJSON = extFormBuilder.build();
					JSONObject mergeInfo = new JSONObject();
					JSONHelper.writeToJSON(mergeInfo, JSONConstants.FORM_FORMINFO, extFormJSON);
					JSONHelper.writeToJSON(formJson, JSONConstants.FORM_DELAYMERGEINFO, mergeInfo);
				}
			}
			
			JSONObject returnJson = new JSONObject();
			returnJson.put("metaForm", formJson);
			returnJson.put("version", metaForm.getVersion());
			return returnJson;
		}
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetFormVersionCmd();
	}

	@Override
	public String getCmd() {
		return "GetFormVersion";
	}

	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
