package com.bokesoft.yes.mid.web.cmd;

import java.util.Iterator;
import java.util.List;

import org.json.JSONArray;
import org.json.JSONObject;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class GetDisplayColumnsCmd extends DefaultServiceCmd {

	private String itemKey = null;
	@Override
	public void dealArguments(DefaultContext context,
			StringHashMap<Object> arguments) throws Throwable {
		itemKey = TypeConvertor.toString(arguments.get("itemKey"));
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		IMetaFactory metaFactory = context.getVE().getMetaFactory();
		MetaDataObject metaDataObj = metaFactory.getDataObject(itemKey);
		List<MetaColumn> list = metaDataObj.getDisplayColumns();
		Iterator<MetaColumn> it = list.iterator();
		MetaColumn column = null;
		JSONArray cols = new JSONArray();
		JSONObject col = null;
		while(it.hasNext()) {
			column = it.next();
			col = new JSONObject();
			col.put("key", column.getKey());
			col.put("caption", MetaUtil.getDataObjectString(metaFactory, context.getVE().getEnv().getLocale(), itemKey, metaDataObj.getMainTableKey(), column.getKey(), column.getCaption()));
			col.put("enable", true);
			col.put("visible", true);
			cols.put(col);
		}
		return cols;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetDisplayColumnsCmd();
	}

	@Override
	public String getCmd() {
		return "GetDisplayColumns";
	}

}
