package com.bokesoft.yes.mid.web.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class GetDataObjectVersionCmd extends DefaultServiceCmd {
	
	private String formKey = null;
	
	private String dataObjectKey = null;
	
	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		formKey = TypeConvertor.toString(arguments.get("formKey"));
		dataObjectKey = TypeConvertor.toString(arguments.get("dataObjectKey"));
	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		
		MetaDataObject meta = null;
		if(dataObjectKey != null && !dataObjectKey.isEmpty()){
			meta = context.getVE().getMetaFactory().getDataObject(dataObjectKey);
			if(meta == null){
				throw new MetaException(MetaException.NO_DATAOBJECT_DEFINED, 
						SimpleStringFormat.format(StringTable.getString(null, "", StringTable.NoDataObjectDefined), dataObjectKey));
			}
		}else if(formKey != null && !formKey.isEmpty()){
			MetaForm metaForm = context.getVE().getMetaFactory().getMetaForm(formKey);
			MetaDataSource dataSource = metaForm.getDataSource();
			if (dataSource != null) {
				meta = dataSource.getDataObject();
			}
		}
		
		int version = 0;
		if(meta != null){
			version = meta.getVersion();
		}
		return version;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetDataObjectVersionCmd();
	}

	@Override
	public String getCmd() {
		return "GetDataObjectVersion";
	}

	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
