package com.bokesoft.yes.mid.web.cmd;

import java.util.ArrayList;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.DefaultServiceCmd;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.def.PlatformType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.mid.base.DefaultContext;

public class GetAliasKeyCmd extends DefaultServiceCmd {
	
	private int platform = PlatformType.All;
	
	private String formKey = "";
	
	private ArrayList<Integer> plats = new ArrayList<>();
	
	
	public GetAliasKeyCmd() {
		this.plats.add(PlatformType.Android);
		this.plats.add(PlatformType.IOS);
		this.plats.add(PlatformType.Mobile);
		this.plats.add(PlatformType.All);
	}
	@Override
	public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
		this.platform = TypeConvertor.toInteger(arguments.get("PlatForm"));
		this.formKey = TypeConvertor.toString(arguments.get("FormKey"));

	}

	@Override
	public Object doCmd(DefaultContext context) throws Throwable {
		IMetaFactory factory = context.getVE().getMetaFactory();
		MetaFormList list = factory.getMetaFormList();
		for(MetaFormProfile profile : list) {
			MetaForm form = profile.getForm();
			if (form == null)
				form = factory.getMetaForm(profile.getKey());
			if (form == null)
				continue;
//			if (plats.contains(form.getPlatform())) {
				String key = form.getAliasKey();
				if (key.equalsIgnoreCase(formKey)) {
					return form.getKey();
				}
//			}
		}
		return null;
	}

	@Override
	public IServiceCmd<DefaultContext> newInstance() {
		return new GetAliasKeyCmd();
	}

	@Override
	public String getCmd() {
		return "GetAliasKey";
	}

	@Override
	public boolean getNeedServiceRight(){
		return true;
	}
}
