/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.view.uistruct.visible;

import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.parser.Lexer;
import com.bokesoft.yes.view.uistruct.ExprItemPos;
import com.bokesoft.yes.view.uistruct.IExprItemObject;
import com.bokesoft.yes.view.uistruct.visible.VisibleAffectItemSet;
import com.bokesoft.yes.view.uistruct.visible.VisibleItem;
import com.bokesoft.yes.view.uistruct.visible.VisibleItemSet;
import com.bokesoft.yes.view.uistruct.visible.VisibleTree;
import com.bokesoft.yigo.meta.base.KeyPairCompositeObject;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.form.MetaBody;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.container.MetaContainer;
import com.bokesoft.yigo.meta.form.component.control.MetaTabGroup;
import com.bokesoft.yigo.meta.form.component.control.MetaTabItem;
import com.bokesoft.yigo.meta.form.component.control.collectionview.MetaCollectionView;
import com.bokesoft.yigo.meta.form.component.control.collectionview.MetaCollectionViewRow;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRow;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableView;
import com.bokesoft.yigo.meta.form.component.grid.MetaExtOpt;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumnCollection;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.view.UIExprManager;
import java.util.Iterator;

public class VisibleTreeBuilder {
    private MetaForm metaForm = null;
    private VisibleTree visibleTree = null;
    private UIExprManager manager = null;

    public VisibleTreeBuilder(MetaForm metaForm, UIExprManager uIExprManager) {
        this.metaForm = metaForm;
        this.manager = uIExprManager;
    }

    public VisibleTree build() throws Throwable {
        this.visibleTree = new VisibleTree();
        this.buildItems();
        this.sortAffect();
        return this.visibleTree;
    }

    private void buildItems() throws Throwable {
        Object object = this.metaForm.getPrimaryBlock().getRoot();
        if (object == null) {
            return;
        }
        Lexer lexer = new Lexer();
        MetaBody metaBody = this.metaForm.getMetaBody();
        boolean bl = Boolean.TRUE.equals(metaBody.isLazyCompute());
        this.buildItems(null, (MetaComponent)object, lexer, bl);
        object = this.metaForm.getOperationCollection();
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                this.buildOperation((KeyPairCompositeObject)object.next(), lexer);
            }
        }
    }

    private void buildItems(MetaComponent metaComponent, MetaComponent metaComponent2, Lexer lexer, boolean bl) throws Throwable {
        this.buildComponentItems(metaComponent, metaComponent2, lexer, bl);
        int n = metaComponent2.getComponentCount();
        for (int i = 0; i < n; ++i) {
            MetaComponent metaComponent3 = metaComponent2.getComponent(i);
            this.buildItems(metaComponent2, metaComponent3, lexer, bl);
        }
    }

    private void buildComponentItems(MetaComponent metaComponent, MetaComponent metaComponent2, Lexer lexer, boolean bl) throws Throwable {
        switch (metaComponent2.getControlType()) {
            case 216: 
            case 300: {
                this.buildHeadItem(metaComponent, metaComponent2, lexer, bl);
                this.buildListViewColumns(metaComponent, (MetaListView)metaComponent2, lexer, bl);
                return;
            }
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 263: 
            case 305: {
                this.buildHeadItem(metaComponent, metaComponent2, lexer, bl);
                this.buildEditViewColumns(metaComponent, (MetaEditView)metaComponent2, lexer, bl);
                return;
            }
            case 264: {
                this.buildHeadItem(metaComponent, metaComponent2, lexer, bl);
                this.buildTableViewItems(metaComponent, (MetaTableView)metaComponent2, lexer, bl);
                this.buildTableViewRows(metaComponent, (MetaTableView)metaComponent2, lexer, bl);
                return;
            }
            case 306: {
                this.buildHeadItem(metaComponent, metaComponent2, lexer, bl);
                this.buildCollectionViewItems(metaComponent, (MetaCollectionView)metaComponent2, lexer, bl);
                this.buildCollectionViewRows(metaComponent, (MetaCollectionView)metaComponent2, lexer, bl);
                return;
            }
            case 217: {
                this.buildHeadItem(metaComponent, metaComponent2, lexer, bl);
                this.buildGridColumns(metaComponent, (MetaGrid)metaComponent2, lexer, bl);
                this.buildGridRows((MetaGrid)metaComponent2);
                this.buildGridOpts((MetaGrid)metaComponent2, lexer);
                return;
            }
            case 262: {
                this.buildHeadItem(metaComponent, metaComponent2, lexer, bl);
                this.buildTabItems(metaComponent, (MetaTabGroup)metaComponent2, lexer, bl);
                return;
            }
            case 228: {
                this.buildHeadItem(metaComponent, metaComponent2, lexer, bl);
                this.buildContainerTabItems(metaComponent, (MetaContainer)metaComponent2, lexer, bl);
                return;
            }
            case 247: 
            case 253: 
            case 20000: {
                return;
            }
        }
        this.buildHeadItem(metaComponent, metaComponent2, lexer, bl);
    }

    private void buildTabItems(MetaComponent metaComponent, MetaTabGroup metaTabGroup, Lexer lexer, boolean bl) {
        for (int i = 0; i < metaTabGroup.getItemCollection().size(); ++i) {
            Object object = (MetaTabItem)metaTabGroup.getItemCollection().get(i);
            String string = object.getKey();
            object = this.manager.createVisibleItem(string, metaTabGroup.getKey(), 0, object.getVisible(), object.getVisibleDependency());
            this.visibleTree.add((IExprItemObject)object);
            if (bl && metaComponent != null) {
                this.visibleTree.addPanelItem(metaComponent.getKey(), (IExprItemObject)object);
            }
            if (string == null || string.isEmpty()) continue;
            this.createAffectMap((VisibleItem)object, lexer);
        }
    }

    private void buildContainerTabItems(MetaComponent metaComponent, MetaContainer metaContainer, Lexer lexer, boolean n) {
        Object object = metaContainer.getTabGroup();
        if (object != null) {
            VisibleItemSet visibleItemSet = new VisibleItemSet(metaContainer.getKey());
            this.visibleTree.add(visibleItemSet);
            if (n != 0 && metaComponent != null) {
                this.visibleTree.addPanelItem(metaComponent.getKey(), visibleItemSet);
            }
            if ((metaComponent = object.getItemCollection()) != null) {
                for (n = 0; n < metaComponent.size(); ++n) {
                    object = (MetaTabItem)metaComponent.get(n);
                    String string = object.getKey();
                    object = this.manager.createVisibleItem(string, metaContainer.getKey(), 1, object.getVisible(), object.getVisibleDependency());
                    ExprItemPos exprItemPos = new ExprItemPos();
                    exprItemPos.setIndex(n);
                    ((VisibleItem)object).setPos(exprItemPos);
                    visibleItemSet.add((IExprItemObject)object);
                    if (string == null || string.isEmpty()) continue;
                    this.createAffectMap((VisibleItem)object, lexer);
                }
            }
        }
    }

    private void buildCollectionViewItems(MetaComponent metaComponent, MetaCollectionView metaCollectionView, Lexer lexer, boolean bl) throws Throwable {
        if ((metaCollectionView = metaCollectionView.getRows()) != null) {
            for (int i = 0; i < metaCollectionView.size(); ++i) {
                MetaComponent metaComponent2 = ((MetaCollectionViewRow)metaCollectionView.get(i)).getRoot();
                this.buildItems(metaComponent, metaComponent2, lexer, bl);
            }
        }
    }

    private void buildCollectionViewRows(MetaComponent metaComponent, MetaCollectionView metaCollectionView, Lexer lexer, boolean bl) {
        if ((metaCollectionView = metaCollectionView.getRows()) != null) {
            for (int i = 0; i < metaCollectionView.size(); ++i) {
                String string;
                Object object = (MetaCollectionViewRow)metaCollectionView.get(i);
                String string2 = string = object.getKey();
                object = this.manager.createVisibleItem(string2, string2, 0, object.getVisible(), object.getVisibleDependency());
                this.visibleTree.add((IExprItemObject)object);
                if (bl && metaComponent != null) {
                    this.visibleTree.addPanelItem(metaComponent.getKey(), (IExprItemObject)object);
                }
                if (string == null || string.isEmpty()) continue;
                this.createAffectMap((VisibleItem)object, lexer);
            }
        }
    }

    private void buildTableViewRows(MetaComponent metaComponent, MetaTableView metaTableView, Lexer lexer, boolean bl) {
        if (metaTableView.getRows() != null) {
            for (int i = 0; i < metaTableView.getRows().size(); ++i) {
                String string;
                Object object = (MetaTableRow)metaTableView.getRows().get(i);
                String string2 = string = object.getKey();
                object = this.manager.createVisibleItem(string2, string2, 0, object.getVisible(), object.getVisibleDependency());
                this.visibleTree.add((IExprItemObject)object);
                if (bl && metaComponent != null) {
                    this.visibleTree.addPanelItem(metaComponent.getKey(), (IExprItemObject)object);
                }
                if (string == null || string.isEmpty()) continue;
                this.createAffectMap((VisibleItem)object, lexer);
            }
        }
    }

    private void buildTableViewItems(MetaComponent metaComponent, MetaTableView metaTableView, Lexer lexer, boolean bl) throws Throwable {
        if ((metaTableView = metaTableView.getRows()) == null) {
            return;
        }
        Iterator iterator = metaTableView.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            MetaTableRow metaTableRow;
            MetaTableRow metaTableRow2 = (MetaTableRow)iterator.next();
            if (metaTableRow2.getRowType() == 0) {
                this.buildItems(metaComponent, metaTableRow2.getRoot(), lexer, bl);
            } else if (metaTableRow2.getRowType() == 1) {
                metaTableRow = null;
                if (n + 1 < metaTableView.size()) {
                    metaTableRow = (MetaTableRow)metaTableView.get(n + 1);
                }
                if (metaTableRow.getRowType() != 2) {
                    this.buildItems(metaComponent, metaTableRow2.getRoot(), lexer, bl);
                }
            } else if (metaTableRow2.getRowType() == 3) {
                metaTableRow = null;
                if (n - 1 >= 0) {
                    metaTableRow = (MetaTableRow)metaTableView.get(n - 1);
                }
                if (metaTableRow.getRowType() != 2) {
                    this.buildItems(metaComponent, metaTableRow2.getRoot(), lexer, bl);
                }
            } else if (metaTableRow2.getRowType() == 2) {
                metaTableRow = new RefObject((Object)0);
                VisibleItemSet visibleItemSet = new VisibleItemSet(metaTableRow2.getKey());
                this.visibleTree.add(visibleItemSet);
                if (bl && metaComponent != null) {
                    this.visibleTree.addPanelItem(metaComponent.getKey(), visibleItemSet);
                }
                this.buildTableViewDetailRowColumns(metaTableRow2.getKey(), metaTableRow2.getRoot(), (RefObject<Integer>)metaTableRow, visibleItemSet, lexer, bl);
            }
            ++n;
        }
    }

    private void buildTableViewDetailRowColumns(String string, MetaComponent metaComponent, RefObject<Integer> refObject, VisibleItemSet visibleItemSet, Lexer lexer, boolean bl) {
        String string2 = metaComponent.getKey();
        VisibleItem visibleItem = this.manager.createVisibleItem(string2, string, 1, metaComponent.getVisible(), metaComponent.getVisibleDependency());
        ExprItemPos exprItemPos = new ExprItemPos();
        int n = (Integer)refObject.getValue();
        exprItemPos.setIndex(n);
        refObject.setValue((Object)(++n));
        visibleItem.setPos(exprItemPos);
        visibleItemSet.add(visibleItem);
        if (string2 != null && !string2.isEmpty()) {
            this.createAffectMap(visibleItem, lexer);
        }
        for (int i = 0; i < metaComponent.getComponentCount(); ++i) {
            visibleItem = metaComponent.getComponent(i);
            this.buildTableViewDetailRowColumns(string, (MetaComponent)visibleItem, refObject, visibleItemSet, lexer, bl);
        }
    }

    private void buildGridRows(MetaGrid metaGrid) {
        for (MetaGridRow metaGridRow : metaGrid.getRowCollection()) {
            Object object;
            if (metaGridRow.getRowType() == 2 || (object = metaGridRow.getVisible()) == null || ((String)object).isEmpty()) continue;
            object = this.manager.createVisibleItem(metaGridRow.getKey(), metaGrid.getKey(), 3, (String)object, "");
            this.visibleTree.put(metaGridRow.getKey(), (VisibleItem)object);
        }
    }

    private void buildGridOpts(MetaGrid metaGrid, Lexer lexer) throws Throwable {
        Object object = metaGrid.getExtOpts();
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                MetaExtOpt metaExtOpt = (MetaExtOpt)object.next();
                VisibleItem visibleItem = this.manager.createVisibleItem(metaExtOpt.getKey(), metaGrid.getKey(), 6, metaExtOpt.getVisible(), metaExtOpt.getVisibleDependency());
                this.visibleTree.add(visibleItem);
                if (metaExtOpt.getKey() == null || metaExtOpt.getKey().isEmpty()) continue;
                this.createAffectMap(visibleItem, lexer);
            }
        }
    }

    private void buildOperation(KeyPairCompositeObject object, Lexer lexer) {
        String string;
        Object object2;
        if (object.getObjectType() == 0) {
            object2 = (MetaOperation)object;
            string = object2.getVisible();
            object = object2.getKey();
            object2 = object2.getVisibleDependency();
        } else {
            object2 = (MetaOperationCollection)object;
            string = object2.getVisible();
            object = object2.getKey();
            object2 = object2.getVisibleDependency();
        }
        Object object3 = object;
        object2 = this.manager.createVisibleItem((String)object3, (String)object3, 2, string, (String)object2);
        if (object2.size() > 0) {
            this.createAffectMap((VisibleItem)object2, lexer);
        }
    }

    private void buildHeadItem(MetaComponent metaComponent, MetaComponent object, Lexer lexer, boolean bl) throws Throwable {
        String string;
        String string2 = string = object.getKey();
        object = this.manager.createVisibleItem(string2, string2, 0, object.getVisible(), object.getVisibleDependency());
        this.visibleTree.add((IExprItemObject)object);
        if (bl && metaComponent != null) {
            this.visibleTree.addPanelItem(metaComponent.getKey(), (IExprItemObject)object);
        }
        if (string != null && !string.isEmpty()) {
            this.createAffectMap((VisibleItem)object, lexer);
        }
    }

    private VisibleItemSet buildGridColumns(MetaComponent metaComponent, MetaGrid metaGrid, Lexer lexer, boolean bl) throws Throwable {
        VisibleItemSet visibleItemSet = new VisibleItemSet(metaGrid.getKey());
        this.visibleTree.add(visibleItemSet);
        if (bl && metaComponent != null) {
            this.visibleTree.addPanelItem(metaComponent.getKey(), visibleItemSet);
        }
        metaComponent = metaGrid.getColumnCollection();
        RefObject refObject = new RefObject((Object)0);
        this.buildColumnsVisible(metaGrid, (MetaGridColumnCollection)metaComponent, visibleItemSet, lexer, (RefObject<Integer>)refObject);
        return visibleItemSet;
    }

    private void buildColumnsVisible(MetaGrid metaGrid, MetaGridColumnCollection metaGridColumnCollection, VisibleItemSet visibleItemSet, Lexer lexer, RefObject<Integer> refObject) throws Throwable {
        for (MetaGridColumn metaGridColumn : metaGridColumnCollection) {
            metaGridColumnCollection = metaGridColumn.getColumnCollection();
            if (metaGridColumnCollection != null && metaGridColumnCollection.size() > 0) {
                this.buildColumnsVisible(metaGrid, metaGridColumnCollection, visibleItemSet, lexer, refObject);
                continue;
            }
            this.buildColumn(metaGrid, metaGridColumn, visibleItemSet, lexer, refObject);
        }
    }

    private void buildColumn(MetaGrid object, MetaGridColumn object2, VisibleItemSet visibleItemSet, Lexer lexer, RefObject<Integer> refObject) throws Throwable {
        String string = object2.getKey();
        object = this.manager.createVisibleItem(string, object.getKey(), 1, object2.getVisible(), object2.getVisibleDependency());
        object2 = new ExprItemPos();
        int n = (Integer)refObject.getValue();
        ((ExprItemPos)object2).setIndex(n);
        refObject.setValue((Object)(++n));
        ((VisibleItem)object).setPos((ExprItemPos)object2);
        visibleItemSet.add((IExprItemObject)object);
        if (string != null && !string.isEmpty()) {
            this.createAffectMap((VisibleItem)object, lexer);
        }
    }

    private VisibleItemSet buildListViewColumns(MetaComponent object, MetaListView metaListView, Lexer lexer, boolean bl) throws Throwable {
        VisibleItemSet visibleItemSet = new VisibleItemSet(metaListView.getKey());
        this.visibleTree.add(visibleItemSet);
        if (bl && object != null) {
            this.visibleTree.addPanelItem(object.getKey(), visibleItemSet);
        }
        object = metaListView.getColumnCollection().iterator();
        bl = false;
        while (object.hasNext()) {
            Object object2 = (MetaListViewColumn)object.next();
            String string = object2.getKey();
            object2 = this.manager.createVisibleItem(string, metaListView.getKey(), 1, object2.getVisible(), object2.getVisibleDependency());
            ExprItemPos exprItemPos = new ExprItemPos();
            exprItemPos.setIndex(bl++ ? 1 : 0);
            ((VisibleItem)object2).setPos(exprItemPos);
            visibleItemSet.add((IExprItemObject)object2);
            if (string == null || string.isEmpty()) continue;
            this.createAffectMap((VisibleItem)object2, lexer);
        }
        return visibleItemSet;
    }

    private VisibleItemSet buildEditViewColumns(MetaComponent object, MetaEditView metaEditView, Lexer lexer, boolean bl) throws Throwable {
        VisibleItemSet visibleItemSet = new VisibleItemSet(metaEditView.getKey());
        this.visibleTree.add(visibleItemSet);
        if (bl && object != null) {
            this.visibleTree.addPanelItem(object.getKey(), visibleItemSet);
        }
        object = metaEditView.getColumnCollection().iterator();
        bl = false;
        while (object.hasNext()) {
            Object object2 = (MetaEditViewColumn)object.next();
            String string = object2.getKey();
            object2 = this.manager.createVisibleItem(string, metaEditView.getKey(), 1, object2.getVisible(), object2.getVisibleDependency());
            ExprItemPos exprItemPos = new ExprItemPos();
            exprItemPos.setIndex(bl++ ? 1 : 0);
            ((VisibleItem)object2).setPos(exprItemPos);
            visibleItemSet.add((IExprItemObject)object2);
            if (string == null || string.isEmpty()) continue;
            this.createAffectMap((VisibleItem)object2, lexer);
        }
        return visibleItemSet;
    }

    private void createAffectMap(VisibleItem visibleItem, Lexer lexer) {
        String string;
        Object object;
        Iterator<Object> iterator = visibleItem.getItems().iterator();
        while (iterator.hasNext()) {
            object = iterator.next().getContent();
            if (object == null || ((String)object).isEmpty()) continue;
            lexer.setContent((String)object);
            int n = lexer.next();
            while (n != -1) {
                if (n == 15) {
                    string = lexer.getLexValue();
                    VisibleAffectItemSet visibleAffectItemSet = this.visibleTree.getAffect(string);
                    if (visibleAffectItemSet == null) {
                        visibleAffectItemSet = new VisibleAffectItemSet(string);
                        this.visibleTree.addAffect(string, visibleAffectItemSet);
                    }
                    visibleAffectItemSet.add(visibleItem);
                }
                n = lexer.next();
            }
        }
        iterator = visibleItem.getDepends().iterator();
        while (iterator.hasNext()) {
            string = ((String)iterator.next()).trim();
            object = this.visibleTree.getAffect(string);
            if (object == null) {
                object = new VisibleAffectItemSet(string);
                this.visibleTree.addAffect(string, (VisibleAffectItemSet)object);
            }
            ((VisibleAffectItemSet)object).add(visibleItem);
        }
    }

    private void sortAffect() {
        this.visibleTree.sortAffect();
    }
}

