/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.view.uistruct.enable;

import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.parser.Lexer;
import com.bokesoft.yes.view.uistruct.ExprItemPos;
import com.bokesoft.yes.view.uistruct.IExprItemObject;
import com.bokesoft.yes.view.uistruct.enable.EnableAffectItemSet;
import com.bokesoft.yes.view.uistruct.enable.EnableItem;
import com.bokesoft.yes.view.uistruct.enable.EnableItemSet;
import com.bokesoft.yes.view.uistruct.enable.EnableTree;
import com.bokesoft.yigo.meta.base.KeyPairCompositeObject;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.collectionview.MetaCollectionView;
import com.bokesoft.yigo.meta.form.component.control.collectionview.MetaCollectionViewRow;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRow;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableView;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.view.UIExprManager;
import java.util.Iterator;

public class EnableTreeBuilder {
    private MetaForm metaForm = null;
    private EnableTree enableTree = null;
    private UIExprManager manager = null;

    public EnableTreeBuilder(MetaForm metaForm, UIExprManager uIExprManager) {
        this.metaForm = metaForm;
        this.manager = uIExprManager;
    }

    public EnableTree build() throws Throwable {
        this.enableTree = new EnableTree();
        this.buildItems();
        this.sortAffect();
        return this.enableTree;
    }

    private void buildItems() throws Throwable {
        Object object = this.metaForm.getPrimaryBlock().getRoot();
        if (object == null) {
            return;
        }
        Lexer lexer = new Lexer();
        boolean bl = this.metaForm.getMetaBody().isLazyCompute();
        this.buildItems(null, (MetaComponent)object, lexer, bl);
        object = this.metaForm.getOperationCollection();
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                this.buildOperation((KeyPairCompositeObject)object.next(), lexer);
            }
        }
    }

    private void buildItems(MetaComponent metaComponent, MetaComponent metaComponent2, Lexer lexer, boolean bl) throws Throwable {
        this.buildComponentItems(metaComponent, metaComponent2, lexer, bl);
        int n = metaComponent2.getComponentCount();
        for (int i = 0; i < n; ++i) {
            MetaComponent metaComponent3 = metaComponent2.getComponent(i);
            this.buildItems(metaComponent2, metaComponent3, lexer, bl);
        }
    }

    private void buildComponentItems(MetaComponent metaComponent, MetaComponent metaComponent2, Lexer lexer, boolean bl) throws Throwable {
        switch (metaComponent2.getControlType()) {
            case 217: {
                this.buildHeadEnable(metaComponent, metaComponent2, lexer, bl);
                this.buildGridItems(metaComponent, (MetaGrid)metaComponent2, lexer, bl);
                return;
            }
            case 216: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 263: 
            case 300: {
                this.buildHeadEnable(metaComponent, metaComponent2, lexer, bl);
                this.buildListViewItems(metaComponent, (MetaListView)metaComponent2, lexer, bl);
                return;
            }
            case 305: {
                this.buildHeadEnable(metaComponent, metaComponent2, lexer, bl);
                this.buildEditViewItems(metaComponent, (MetaEditView)metaComponent2, lexer, bl);
                return;
            }
            case 264: {
                this.buildHeadEnable(metaComponent, metaComponent2, lexer, bl);
                this.buildTableViewItems(metaComponent, (MetaTableView)metaComponent2, lexer, bl);
                this.buildTableViewRows(metaComponent, (MetaTableView)metaComponent2, lexer, bl);
                return;
            }
            case 306: {
                this.buildHeadEnable(metaComponent, metaComponent2, lexer, bl);
                this.buildCollectionViewItems(metaComponent, (MetaCollectionView)metaComponent2, lexer, bl);
                this.buildCollectionViewRows(metaComponent, (MetaCollectionView)metaComponent2, lexer, bl);
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 223: 
            case 247: 
            case 253: 
            case 20000: {
                return;
            }
        }
        this.buildHeadEnable(metaComponent, metaComponent2, lexer, bl);
    }

    private void buildCollectionViewItems(MetaComponent metaComponent, MetaCollectionView metaCollectionView, Lexer lexer, boolean bl) throws Throwable {
        if ((metaCollectionView = metaCollectionView.getRows()) != null) {
            for (int i = 0; i < metaCollectionView.size(); ++i) {
                MetaComponent metaComponent2 = ((MetaCollectionViewRow)metaCollectionView.get(i)).getRoot();
                this.buildItems(metaComponent, metaComponent2, lexer, bl);
            }
        }
    }

    private void buildCollectionViewRows(MetaComponent metaComponent, MetaCollectionView metaCollectionView, Lexer lexer, boolean bl) {
        if ((metaCollectionView = metaCollectionView.getRows()) != null) {
            for (int i = 0; i < metaCollectionView.size(); ++i) {
                MetaCollectionViewRow metaCollectionViewRow = (MetaCollectionViewRow)metaCollectionView.get(i);
                Object object = metaCollectionViewRow.getEnable();
                if (object == null || ((String)object).isEmpty()) continue;
                object = this.manager.createEnableItem(metaCollectionViewRow.getKey(), metaCollectionViewRow.getKey(), 0, metaCollectionViewRow.getEnable(), metaCollectionViewRow.getEnableDependency());
                this.enableTree.add((IExprItemObject)object);
                if (bl && metaComponent != null) {
                    this.enableTree.addPanelItem(metaComponent.getKey(), (IExprItemObject)object);
                }
                if (metaCollectionViewRow.getKey() == null || metaCollectionViewRow.getKey().isEmpty()) continue;
                this.createAffectMap((EnableItem)object, lexer);
            }
        }
    }

    private void buildTableViewRows(MetaComponent metaComponent, MetaTableView metaTableView, Lexer lexer, boolean bl) {
        if ((metaTableView = metaTableView.getRows()) != null) {
            for (int i = 0; i < metaTableView.size(); ++i) {
                MetaTableRow metaTableRow = (MetaTableRow)metaTableView.get(i);
                Object object = metaTableRow.getEnable();
                if (object == null || ((String)object).isEmpty()) continue;
                object = this.manager.createEnableItem(metaTableRow.getKey(), metaTableRow.getKey(), 0, metaTableRow.getEnable(), metaTableRow.getEnableDependency());
                this.enableTree.add((IExprItemObject)object);
                if (bl && metaComponent != null) {
                    this.enableTree.addPanelItem(metaComponent.getKey(), (IExprItemObject)object);
                }
                if (metaTableRow.getKey() == null || metaTableRow.getKey().isEmpty()) continue;
                this.createAffectMap((EnableItem)object, lexer);
            }
        }
    }

    private void buildTableViewItems(MetaComponent metaComponent, MetaTableView metaTableView, Lexer lexer, boolean bl) throws Throwable {
        if ((metaTableView = metaTableView.getRows()) == null) {
            return;
        }
        Iterator iterator = metaTableView.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            RefObject refObject;
            MetaTableRow metaTableRow = (MetaTableRow)iterator.next();
            if (metaTableRow.getRowType() == 0) {
                this.buildItems(metaComponent, metaTableRow.getRoot(), lexer, bl);
            } else if (metaTableRow.getRowType() == 1) {
                refObject = null;
                if (n + 1 < metaTableView.size()) {
                    refObject = (MetaTableRow)metaTableView.get(n + 1);
                }
                if (refObject.getRowType() != 2) {
                    this.buildItems(metaComponent, metaTableRow.getRoot(), lexer, bl);
                }
            } else if (metaTableRow.getRowType() == 3) {
                refObject = null;
                if (n - 1 >= 0) {
                    refObject = (MetaTableRow)metaTableView.get(n - 1);
                }
                if (refObject.getRowType() != 2) {
                    this.buildItems(metaComponent, metaTableRow.getRoot(), lexer, bl);
                }
            } else if (metaTableRow.getRowType() == 2) {
                refObject = new RefObject((Object)0);
                EnableItemSet enableItemSet = new EnableItemSet(metaTableRow.getKey());
                this.enableTree.add(enableItemSet);
                if (bl && metaComponent != null) {
                    this.enableTree.addPanelItem(metaComponent.getKey(), enableItemSet);
                }
                this.buildTableViewDetailRowColumns(metaTableRow.getKey(), metaTableRow.getRoot(), (RefObject<Integer>)refObject, enableItemSet, lexer, bl);
            }
            ++n;
        }
    }

    private void buildTableViewDetailRowColumns(String string, MetaComponent metaComponent, RefObject<Integer> refObject, EnableItemSet enableItemSet, Lexer lexer, boolean bl) {
        String string2 = metaComponent.getKey();
        EnableItem enableItem = this.manager.createEnableItem(string2, string, 1, metaComponent.getEnable(), metaComponent.getEnableDependency());
        ExprItemPos exprItemPos = new ExprItemPos();
        int n = (Integer)refObject.getValue();
        exprItemPos.setIndex(n);
        refObject.setValue((Object)(++n));
        enableItem.setPos(exprItemPos);
        enableItemSet.add(enableItem);
        if (string2 != null && !string2.isEmpty()) {
            this.createAffectMap(enableItem, lexer);
        }
        for (int i = 0; i < metaComponent.getComponentCount(); ++i) {
            enableItem = metaComponent.getComponent(i);
            this.buildTableViewDetailRowColumns(string, (MetaComponent)enableItem, refObject, enableItemSet, lexer, bl);
        }
    }

    private void buildOperation(KeyPairCompositeObject object, Lexer lexer) {
        String string;
        String string2;
        Object object2;
        if (object.getObjectType() == 0) {
            object2 = (MetaOperation)object;
            string2 = object2.getEnable();
            string = object2.getKey();
            object2 = object2.getEnableDependency();
        } else {
            object2 = (MetaOperationCollection)object;
            string2 = object2.getEnable();
            string = object2.getKey();
            object2 = object2.getEnableDependency();
        }
        if (string2 != null && !string2.isEmpty()) {
            String string3 = string;
            object2 = this.manager.createEnableItem(string3, string3, 2, string2, (String)object2);
            this.enableTree.add((IExprItemObject)object2);
            this.createAffectMap((EnableItem)object2, lexer);
        }
        if (object.getObjectType() == 1) {
            object = ((MetaOperationCollection)object).iterator();
            while (object.hasNext()) {
                this.buildOperation((KeyPairCompositeObject)object.next(), lexer);
            }
        }
    }

    private void buildHeadEnable(MetaComponent metaComponent, MetaComponent object, Lexer lexer, boolean bl) throws Throwable {
        String string;
        String string2 = string = object.getKey();
        object = this.manager.createEnableItem(string2, string2, 0, object.getEnable(), object.getEnableDependency());
        this.enableTree.add((IExprItemObject)object);
        if (bl && metaComponent != null) {
            this.enableTree.addPanelItem(metaComponent.getKey(), (IExprItemObject)object);
        }
        if (string != null && !string.isEmpty()) {
            this.createAffectMap((EnableItem)object, lexer);
        }
    }

    private void buildListViewItems(MetaComponent object, MetaListView metaListView, Lexer lexer, boolean bl) throws Throwable {
        EnableItemSet enableItemSet = new EnableItemSet(metaListView.getKey());
        this.enableTree.add(enableItemSet);
        if (bl && object != null) {
            this.enableTree.addPanelItem(object.getKey(), enableItemSet);
        }
        object = metaListView.getColumnCollection().iterator();
        bl = false;
        while (object.hasNext()) {
            Object object2 = (MetaListViewColumn)object.next();
            String string = object2.getKey();
            object2 = this.manager.createEnableItem(string, metaListView.getKey(), 1, object2.getEnable(), object2.getEnableDependency());
            ExprItemPos exprItemPos = new ExprItemPos();
            exprItemPos.setIndex(bl++ ? 1 : 0);
            ((EnableItem)object2).setPos(exprItemPos);
            enableItemSet.add((IExprItemObject)object2);
            if (string == null || string.isEmpty()) continue;
            this.createAffectMap((EnableItem)object2, lexer);
        }
    }

    private void buildEditViewItems(MetaComponent object, MetaEditView metaEditView, Lexer lexer, boolean bl) throws Throwable {
        EnableItemSet enableItemSet = new EnableItemSet(metaEditView.getKey());
        this.enableTree.add(enableItemSet);
        if (bl && object != null) {
            this.enableTree.addPanelItem(object.getKey(), enableItemSet);
        }
        object = metaEditView.getColumnCollection().iterator();
        bl = false;
        while (object.hasNext()) {
            Object object2 = (MetaEditViewColumn)object.next();
            String string = object2.getKey();
            object2 = this.manager.createEnableItem(string, metaEditView.getKey(), 1, object2.getEnable(), object2.getEnableDependency());
            ExprItemPos exprItemPos = new ExprItemPos();
            exprItemPos.setIndex(bl++ ? 1 : 0);
            ((EnableItem)object2).setPos(exprItemPos);
            enableItemSet.add((IExprItemObject)object2);
            if (string == null || string.isEmpty()) continue;
            this.createAffectMap((EnableItem)object2, lexer);
        }
    }

    private void buildGridItems(MetaComponent metaComponent, MetaGrid metaGrid, Lexer lexer, boolean bl) throws Throwable {
        EnableItemSet enableItemSet = new EnableItemSet(metaGrid.getKey());
        this.enableTree.add(enableItemSet);
        if (bl && metaComponent != null) {
            this.enableTree.addPanelItem(metaComponent.getKey(), enableItemSet);
        }
        for (MetaGridRow metaGridRow : metaGrid.getRowCollection()) {
            int n = metaGridRow.getRowType();
            if (n != 2 && n != 0) continue;
            int n2 = metaGridRow.size();
            for (int i = 0; i < n2; ++i) {
                Object object = (MetaGridCell)metaGridRow.get(i);
                String string = object.getKey();
                object = this.manager.createEnableItem(string, metaGrid.getKey(), n == 2 ? 1 : 0, this.getCellEnable(metaGrid, (MetaGridCell)object, i), object.getEnableDependency());
                ExprItemPos exprItemPos = new ExprItemPos();
                exprItemPos.setIndex(i);
                ((EnableItem)object).setPos(exprItemPos);
                if (n == 2) {
                    enableItemSet.add((IExprItemObject)object);
                } else {
                    this.enableTree.add((IExprItemObject)object);
                    if (bl && metaComponent != null) {
                        this.enableTree.addPanelItem(metaComponent.getKey(), (IExprItemObject)object);
                    }
                }
                if (string == null || string.isEmpty()) continue;
                this.createAffectMap((EnableItem)object, lexer);
            }
        }
    }

    private String getCellEnable(MetaGrid metaGrid, MetaGridCell object, int n) {
        if (((object = object.getEnable()) == null || ((String)object).isEmpty()) && ((object = metaGrid.getLeafColumn(n).getEnable()) == null || ((String)object).isEmpty())) {
            object = metaGrid.getEnable();
        }
        return object;
    }

    private void createAffectMap(EnableItem enableItem, Lexer lexer) {
        String string;
        Object object;
        Iterator<Object> iterator = enableItem.getItems().iterator();
        while (iterator.hasNext()) {
            object = iterator.next().getContent();
            if (object == null || ((String)object).isEmpty()) continue;
            lexer.setContent((String)object);
            int n = lexer.next();
            while (n != -1) {
                if (n == 15) {
                    string = lexer.getLexValue();
                    EnableAffectItemSet enableAffectItemSet = this.enableTree.getAffect(string);
                    if (enableAffectItemSet == null) {
                        enableAffectItemSet = new EnableAffectItemSet(string);
                        this.enableTree.addAffect(string, enableAffectItemSet);
                    }
                    enableAffectItemSet.add(enableItem);
                }
                n = lexer.next();
            }
        }
        iterator = enableItem.getDepends().iterator();
        while (iterator.hasNext()) {
            string = ((String)iterator.next()).trim();
            object = this.enableTree.getAffect(string);
            if (object == null) {
                object = new EnableAffectItemSet(string);
                this.enableTree.addAffect(string, (EnableAffectItemSet)object);
            }
            ((EnableAffectItemSet)object).add(enableItem);
        }
    }

    private void sortAffect() {
        this.enableTree.sortAffect();
    }
}

