/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.view.uistruct.checkrule;

import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.parser.Lexer;
import com.bokesoft.yes.view.uistruct.ExprItemPos;
import com.bokesoft.yes.view.uistruct.IExprItemObject;
import com.bokesoft.yes.view.uistruct.checkrule.CheckRuleAffectItemSet;
import com.bokesoft.yes.view.uistruct.checkrule.CheckRuleItem;
import com.bokesoft.yes.view.uistruct.checkrule.CheckRuleItemSet;
import com.bokesoft.yes.view.uistruct.checkrule.CheckRuleTree;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.component.MetaComponent;
import com.bokesoft.yigo.meta.form.component.control.collectionview.MetaCollectionView;
import com.bokesoft.yigo.meta.form.component.control.collectionview.MetaCollectionViewRow;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditViewColumn;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListView;
import com.bokesoft.yigo.meta.form.component.control.listview.MetaListViewColumn;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableRow;
import com.bokesoft.yigo.meta.form.component.control.tableview.MetaTableView;
import com.bokesoft.yigo.meta.form.component.grid.MetaGrid;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridRow;
import com.bokesoft.yigo.view.UIExprManager;
import java.util.Iterator;
import java.util.List;

public class CheckRuleTreeBuilder {
    private MetaForm metaForm = null;
    private UIExprManager manager = null;
    private CheckRuleTree checkRuleTree = null;

    public CheckRuleTreeBuilder(MetaForm metaForm, UIExprManager uIExprManager) {
        this.metaForm = metaForm;
        this.manager = uIExprManager;
    }

    public CheckRuleTree build() throws Throwable {
        this.checkRuleTree = new CheckRuleTree();
        this.buildItems();
        this.checkRuleTree.setGlobalItems(this.manager.createCheckRuleItems(this.metaForm.getKey(), this.metaForm.getKey(), this.metaForm.getUICheckRuleCollection()));
        this.sortAffect();
        return this.checkRuleTree;
    }

    private void buildItems() throws Throwable {
        Lexer lexer = new Lexer();
        block8: for (MetaComponent metaComponent : this.metaForm.getAllComponents()) {
            switch (metaComponent.getControlType()) {
                case 217: {
                    this.buildGridItems((MetaGrid)metaComponent, lexer);
                    continue block8;
                }
                case 216: 
                case 256: 
                case 257: 
                case 258: 
                case 259: 
                case 263: {
                    this.buildListItems((MetaListView)metaComponent, lexer);
                    continue block8;
                }
                case 305: {
                    this.buildEditViewItems((MetaEditView)metaComponent, lexer);
                    continue block8;
                }
                case 264: {
                    this.buildTableViewItems((MetaTableView)metaComponent, lexer);
                    continue block8;
                }
                case 306: {
                    this.buildCollectionViewItems((MetaCollectionView)metaComponent, lexer);
                    continue block8;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 200: 
                case 203: 
                case 207: 
                case 209: 
                case 223: 
                case 226: 
                case 227: 
                case 228: 
                case 239: 
                case 244: 
                case 245: 
                case 247: 
                case 251: 
                case 253: 
                case 262: 
                case 20000: {
                    continue block8;
                }
            }
            this.buildHeadItem(metaComponent, lexer);
        }
    }

    private void buildTableViewItems(MetaTableView metaTableView, Lexer lexer) throws Throwable {
        if ((metaTableView = metaTableView.getRows()) != null) {
            Iterator iterator = metaTableView.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                Object object;
                MetaTableRow metaTableRow = (MetaTableRow)iterator.next();
                if (metaTableRow.getRowType() == 0) {
                    object = metaTableRow.getRoot();
                    this.buildTableViewFixRowItems((MetaComponent)object, lexer);
                } else if (metaTableRow.getRowType() == 1) {
                    object = null;
                    if (n + 1 < metaTableView.size()) {
                        object = (MetaTableRow)metaTableView.get(n + 1);
                    }
                    if (object.getRowType() != 2) {
                        this.buildTableViewFixRowItems(metaTableRow.getRoot(), lexer);
                    }
                } else if (metaTableRow.getRowType() == 3) {
                    object = null;
                    if (n - 1 >= 0) {
                        object = (MetaTableRow)metaTableView.get(n - 1);
                    }
                    if (object.getRowType() != 2) {
                        this.buildTableViewFixRowItems(metaTableRow.getRoot(), lexer);
                    }
                } else if (metaTableRow.getRowType() == 2) {
                    object = new CheckRuleItemSet(metaTableRow.getKey());
                    this.checkRuleTree.add((IExprItemObject)object);
                    RefObject refObject = new RefObject((Object)0);
                    this.buildTableViewDetailRowItems(metaTableRow.getKey(), metaTableRow.getRoot(), (CheckRuleItemSet)object, (RefObject<Integer>)refObject, lexer);
                }
                ++n;
            }
        }
    }

    private void buildTableViewDetailRowItems(String string, MetaComponent metaComponent, CheckRuleItemSet checkRuleItemSet, RefObject<Integer> refObject, Lexer lexer) {
        String string2 = metaComponent.getKey();
        CheckRuleItem checkRuleItem = this.manager.createCheckRuleItem(metaComponent.getKey(), string, 1, metaComponent.getCheckRule(), metaComponent.getErrorInfo(), metaComponent.isRequired(), metaComponent.getCheckDependency());
        ExprItemPos exprItemPos = new ExprItemPos();
        int n = (Integer)refObject.getValue();
        exprItemPos.setIndex(n);
        refObject.setValue((Object)(++n));
        checkRuleItem.setPos(exprItemPos);
        checkRuleItemSet.add(checkRuleItem);
        if (string2 != null && !string2.isEmpty()) {
            this.createAffectMap(checkRuleItem, lexer);
        }
        for (int i = 0; i < metaComponent.getComponentCount(); ++i) {
            this.buildTableViewDetailRowItems(string, metaComponent.getComponent(i), checkRuleItemSet, refObject, lexer);
        }
    }

    private void buildTableViewFixRowItems(MetaComponent metaComponent, Lexer lexer) throws Throwable {
        if (metaComponent != null) {
            this.buildHeadItem(metaComponent, lexer);
        }
        if (metaComponent.getComponentCount() > 0) {
            for (int i = 0; i < metaComponent.getComponentCount(); ++i) {
                MetaComponent metaComponent2 = metaComponent.getComponent(i);
                this.buildTableViewFixRowItems(metaComponent2, lexer);
            }
        }
    }

    private void buildCollectionViewItems(MetaCollectionView metaCollectionView, Lexer lexer) throws Throwable {
        if ((metaCollectionView = metaCollectionView.getRows()) != null) {
            for (int i = 0; i < metaCollectionView.size(); ++i) {
                MetaComponent metaComponent = ((MetaCollectionViewRow)metaCollectionView.get(i)).getRoot();
                this.buildTableViewFixRowItems(metaComponent, lexer);
            }
        }
    }

    private void buildHeadItem(MetaComponent object, Lexer lexer) throws Throwable {
        String string;
        String string2 = string = object.getKey();
        object = this.manager.createCheckRuleItem(string2, string2, 0, object.getCheckRule(), object.getErrorInfo(), object.isRequired(), object.getCheckDependency());
        this.checkRuleTree.add((IExprItemObject)object);
        if (string != null && !string.isEmpty()) {
            this.createAffectMap((CheckRuleItem)object, lexer);
        }
    }

    private void buildGridItems(MetaGrid metaGrid, Lexer lexer) throws Throwable {
        CheckRuleItemSet checkRuleItemSet = new CheckRuleItemSet(metaGrid.getKey());
        this.checkRuleTree.add(checkRuleItemSet);
        for (MetaGridRow metaGridRow : metaGrid.getRowCollection()) {
            Object object2;
            int n = metaGridRow.getRowType();
            if (n != 2 && n != 0) continue;
            int n2 = 0;
            for (Object object2 : metaGridRow) {
                String string = object2.getKey();
                object2 = this.manager.createCheckRuleItem(string, metaGrid.getKey(), n == 2 ? 1 : 0, object2.getCheckRule(), object2.getErrorInfo(), object2.isRequired(), object2.getCheckDependency());
                ExprItemPos exprItemPos = new ExprItemPos();
                exprItemPos.setIndex(n2++);
                ((CheckRuleItem)object2).setPos(exprItemPos);
                if (n == 2) {
                    checkRuleItemSet.add((CheckRuleItem)object2);
                } else {
                    this.checkRuleTree.add((IExprItemObject)object2);
                }
                if (string == null || string.isEmpty()) continue;
                this.createAffectMap((CheckRuleItem)object2, lexer);
            }
            if (n != 2 || (object2 = this.manager.createCheckRuleItems(metaGridRow.getKey(), metaGrid.getKey(), metaGridRow.getCheckRuleCollection())) == null) continue;
            this.checkRuleTree.setRowItems(metaGridRow.getKey(), (List<CheckRuleItem>)object2);
        }
    }

    private void buildListItems(MetaListView metaListView, Lexer lexer) throws Throwable {
        CheckRuleItemSet checkRuleItemSet = new CheckRuleItemSet(metaListView.getKey());
        this.checkRuleTree.add(checkRuleItemSet);
        Iterator iterator = metaListView.getColumnCollection().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object object = (MetaListViewColumn)iterator.next();
            String string = object.getKey();
            object = this.manager.createCheckRuleItem(object.getKey(), metaListView.getKey(), 1, object.getCheckRule(), object.getErrorInfo(), object.isRequired(), object.getCheckDependency());
            ExprItemPos exprItemPos = new ExprItemPos();
            exprItemPos.setIndex(n++);
            ((CheckRuleItem)object).setPos(exprItemPos);
            checkRuleItemSet.add((CheckRuleItem)object);
            if (string == null || string.isEmpty()) continue;
            this.createAffectMap((CheckRuleItem)object, lexer);
        }
    }

    private void buildEditViewItems(MetaEditView metaEditView, Lexer lexer) throws Throwable {
        CheckRuleItemSet checkRuleItemSet = new CheckRuleItemSet(metaEditView.getKey());
        this.checkRuleTree.add(checkRuleItemSet);
        Iterator iterator = metaEditView.getColumnCollection().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            Object object = (MetaEditViewColumn)iterator.next();
            String string = object.getKey();
            object = this.manager.createCheckRuleItem(object.getKey(), metaEditView.getKey(), 1, object.getCheckRule(), object.getErrorInfo(), object.isRequired(), object.getCheckDependency());
            ExprItemPos exprItemPos = new ExprItemPos();
            exprItemPos.setIndex(n++);
            ((CheckRuleItem)object).setPos(exprItemPos);
            checkRuleItemSet.add((CheckRuleItem)object);
            if (string == null || string.isEmpty()) continue;
            this.createAffectMap((CheckRuleItem)object, lexer);
        }
    }

    private void createAffectMap(CheckRuleItem checkRuleItem, Lexer lexer) {
        Object object;
        boolean bl = false;
        String string = checkRuleItem.getTarget();
        Object object2 = checkRuleItem.getItems().iterator();
        while (object2.hasNext()) {
            object = object2.next().getContent();
            if (object == null || ((String)object).isEmpty()) continue;
            lexer.setContent((String)object);
            int n = lexer.next();
            while (n != -1) {
                if (n == 15) {
                    object = lexer.getLexValue();
                    CheckRuleAffectItemSet checkRuleAffectItemSet = this.checkRuleTree.getAffect((String)object);
                    if (checkRuleAffectItemSet == null) {
                        checkRuleAffectItemSet = new CheckRuleAffectItemSet((String)object);
                        this.checkRuleTree.addAffect((String)object, checkRuleAffectItemSet);
                    }
                    checkRuleAffectItemSet.add(checkRuleItem);
                    if (((String)object).equals(string)) {
                        bl = true;
                    }
                }
                n = lexer.next();
            }
        }
        object2 = checkRuleItem.getDepends().iterator();
        while (object2.hasNext()) {
            String string2 = ((String)object2.next()).trim();
            object = this.checkRuleTree.getAffect(string2);
            if (object == null) {
                object = new CheckRuleAffectItemSet(string2);
                this.checkRuleTree.addAffect(string2, (CheckRuleAffectItemSet)object);
            }
            ((CheckRuleAffectItemSet)object).add(checkRuleItem);
            if (!string2.equals(string)) continue;
            bl = true;
        }
        if (!bl) {
            object2 = this.checkRuleTree.getAffect(string);
            if (object2 == null) {
                object2 = new CheckRuleAffectItemSet(string);
                this.checkRuleTree.addAffect(string, (CheckRuleAffectItemSet)object2);
            }
            ((CheckRuleAffectItemSet)object2).add(checkRuleItem);
        }
    }

    private void sortAffect() {
        this.checkRuleTree.sortAffect();
    }
}

