/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.certificate;

import com.bokesoft.yes.common.util.CertificateBase64Utils;
import com.bokesoft.yes.common.util.RSAEncrypt;
import com.bokesoft.yes.mid.certificate.AbstractCertificateWarehouse;
import com.bokesoft.yigo.mid.base.CertificateException;
import com.bokesoft.yigo.mid.base.DefaultContext;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Date;

public class UserCertificateWarehouseForDB
extends AbstractCertificateWarehouse<Long> {
    private static String USER_KEY = "OperatorID";
    private static String PRIVATE_KEY = "PrivateKey";
    private static String FINGERPRINT = "Fingerprint";
    private static String OPERATORID = "OperatorID";
    private static String ALIAS = "Alias";
    private static String CERTIFICATE_TABLENAME = "sys_operatorcertificate";

    @Override
    protected void initKeyAndAlias(DefaultContext defaultContext) throws Throwable {
        defaultContext = defaultContext.getDBManager().execQuery("select " + USER_KEY + "," + ALIAS + " from " + CERTIFICATE_TABLENAME + " where flag=1");
        defaultContext.beforeFirst();
        while (defaultContext.next()) {
            this.addKey(defaultContext.getLong(USER_KEY), defaultContext.getString(ALIAS));
        }
    }

    @Override
    protected PrivateKey getPrivateKey(DefaultContext defaultContext, Long l2, String object) throws Throwable {
        defaultContext = defaultContext.getDBManager();
        object = new Date(defaultContext.getCurTime());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select ").append(PRIVATE_KEY).append(" from ").append(CERTIFICATE_TABLENAME).append(" where operatorid=? and starttime<=? and endtime>=? and flag=1");
        defaultContext = defaultContext.execPrepareQuery(stringBuilder.toString(), new Object[]{l2, object, object});
        if (defaultContext.size() == 0) {
            throw new CertificateException(1, "Certificate not found or expired!");
        }
        defaultContext.first();
        return RSAEncrypt.loadPrivateKeyByStr((String)defaultContext.getString(PRIVATE_KEY));
    }

    @Override
    protected boolean doCheck(String string, String object, PrivateKey privateKey) {
        try {
            object = RSAEncrypt.decrypt((RSAPrivateKey)((RSAPrivateKey)privateKey), (byte[])CertificateBase64Utils.decode((String)object));
            return new String((byte[])object).equals(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    @Override
    protected String getFingerprint(DefaultContext defaultContext, Long l2) throws Throwable {
        defaultContext = defaultContext.getDBManager();
        Date date = new Date(defaultContext.getCurTime());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select ").append(FINGERPRINT).append(" from ").append(CERTIFICATE_TABLENAME).append(" where operatorid=? and starttime<=? and endtime>=? and flag=1");
        defaultContext = defaultContext.execPrepareQuery(stringBuilder.toString(), new Object[]{l2, date, date});
        if (defaultContext.size() == 0) {
            throw new CertificateException(1, "Fingerprint not found or expired!");
        }
        defaultContext.first();
        return defaultContext.getString(FINGERPRINT);
    }

    @Override
    protected void doCheckFingerprint(String string, String string2, String object, PrivateKey serializable) {
        try {
            object = RSAEncrypt.decrypt((RSAPrivateKey)((RSAPrivateKey)serializable), (byte[])CertificateBase64Utils.decode((String)object));
            object = new String((byte[])object);
            serializable = new StringBuilder();
            ((StringBuilder)serializable).append(string2).append("|").append(string);
            string = ((StringBuilder)serializable).toString();
            if (!((String)object).equals(string)) {
                throw new CertificateException(1, "Fingerprint check error!");
            }
            return;
        }
        catch (Exception exception) {
            throw new CertificateException(1, "Fingerprint check error!");
        }
    }

    @Override
    public Long getOperatorIDByFingerprint(DefaultContext defaultContext, String string) throws Throwable {
        defaultContext = defaultContext.getDBManager();
        Date date = new Date(defaultContext.getCurTime());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select ").append(OPERATORID).append(" from ").append(CERTIFICATE_TABLENAME).append(" where starttime<=? and endtime>=? and flag=1 and fingerprint=?");
        defaultContext = defaultContext.execPrepareQuery(stringBuilder.toString(), new Object[]{date, date, string});
        if (defaultContext.size() == 0) {
            return -1L;
        }
        defaultContext.first();
        return defaultContext.getLong(OPERATORID);
    }
}

