/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.session;

import com.bokesoft.yes.mid.redis.RedisCache;
import com.bokesoft.yes.mid.util.PropertyUtil;
import com.bokesoft.yigo.cache.ICache;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.mid.nosql.Connection;
import com.bokesoft.yigo.mid.nosql.ConnectionFactory;
import com.bokesoft.yigo.mid.session.ICacheFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class RedisSessionCacheFactory
implements ICacheFactory {
    private Properties properties;

    public RedisSessionCacheFactory(IMetaFactory iMetaFactory) {
        this.init();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init() {
        InputStream inputStream = null;
        try {
            inputStream = PropertyUtil.readProperties((String)"redis-session.properties");
            Object object = "redis-session-cluster.properties";
            if (inputStream == null) {
                inputStream = PropertyUtil.readProperties((String)"redis.properties");
                object = "redis-cluster.properties";
            }
            if (inputStream == null) {
                throw new MidCoreException(36, MidCoreException.formatMessage(null, (int)36, (Object[])new Object[0]));
            }
            this.properties = new Properties();
            this.properties.load(inputStream);
            boolean bl = false;
            if (this.properties.containsKey("Cluster") && (bl = Boolean.parseBoolean(this.properties.getProperty("Cluster")))) {
                object = PropertyUtil.readProperties((String)object);
                try {
                    this.properties = new Properties();
                    this.properties.load((InputStream)object);
                }
                finally {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
            }
            this.properties.setProperty("cluster", String.valueOf(bl));
            if (inputStream == null) return;
        }
        catch (MidCoreException midCoreException) {
            try {
                throw midCoreException;
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                throw throwable;
            }
        }
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
    }

    public <V> ICache<V> createCache(String string) {
        Connection connection = ConnectionFactory.getInstance().getConnection(this.properties);
        return new RedisCache(string, connection);
    }
}

