/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.validate.simple;

import com.bokesoft.yigo.validate.ValidateCodeInfo;
import com.bokesoft.yigo.validate.simple.ImgFontByte;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Random;
import javax.imageio.ImageIO;

public class ValidateCodeUtil {
    private static int width = 120;
    private static int height = 40;
    private static int codeCount = 5;
    private static int lineCount = 150;
    private static String code = null;
    private static BufferedImage buffImg = null;
    private static char[] codeSequence = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    private ValidateCodeUtil() {
    }

    public static ValidateCodeInfo newValidataCodeInfo() throws IOException {
        ValidateCodeUtil.createCode();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)buffImg, "png", byteArrayOutputStream);
        return new ValidateCodeInfo(code, byteArrayOutputStream.toByteArray());
    }

    protected static void createCode() {
        int n2;
        int n3;
        int n4;
        int n5 = width / (codeCount + 2);
        int n6 = height - 2;
        int n7 = height - 4;
        buffImg = new BufferedImage(width, height, 1);
        Graphics2D graphics2D = buffImg.createGraphics();
        Random random = new Random();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, width, height);
        Font font = new ImgFontByte().getFont(n6);
        graphics2D.setFont(font);
        for (int i2 = 0; i2 < lineCount; ++i2) {
            n4 = random.nextInt(width);
            int n8 = random.nextInt(height);
            int n9 = n4 + random.nextInt(width / 8);
            int n10 = n8 + random.nextInt(height / 8);
            int n11 = random.nextInt(255);
            n3 = random.nextInt(255);
            n2 = random.nextInt(255);
            graphics2D.setColor(new Color(n11, n3, n2));
            graphics2D.drawLine(n4, n8, n9, n10);
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n4 = 0; n4 < codeCount; ++n4) {
            String string = String.valueOf(codeSequence[random.nextInt(codeSequence.length)]);
            int n12 = random.nextInt(255);
            n3 = random.nextInt(255);
            n2 = random.nextInt(255);
            graphics2D.setColor(new Color(n12, n3, n2));
            graphics2D.drawString(string, (n4 + 1) * n5, n7);
            stringBuffer.append(string);
        }
        code = stringBuffer.toString();
    }
}

