/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.mid.auth;

import com.bokesoft.yes.mid.auth.LoginUtil;
import com.bokesoft.yes.mid.auth.UserInfoUtil;
import com.bokesoft.yes.mid.auth.cache.SessionInfo;
import com.bokesoft.yes.mid.base.ServerSetting;
import com.bokesoft.yes.mid.base.SvrInfo;
import com.bokesoft.yes.mid.certificate.cmd.CheckCertificateCmd;
import com.bokesoft.yes.mid.certificate.utils.MidPasswordRuleChecker;
import com.bokesoft.yes.mid.connection.DBUtil;
import com.bokesoft.yes.mid.connection.dbmanager.PSArgs;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.session.AccountLockoutInfoProvider;
import com.bokesoft.yes.mid.session.IAccountLockoutInfoMap;
import com.bokesoft.yes.mid.session.ISessionLog;
import com.bokesoft.yes.mid.session.SessionTicketidRecorder;
import com.bokesoft.yes.mid.session.SysSessionLog;
import com.bokesoft.yes.mid.session.UserRoleUtil;
import com.bokesoft.yes.mid.util.AuthUtil;
import com.bokesoft.yes.tools.json.JSONUtil;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.common.exception.CoreException;
import com.bokesoft.yigo.common.i18n.ILocale;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.setting.MetaSession;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.mid.auth.GuestLoginInfo;
import com.bokesoft.yigo.mid.base.CertificateException;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IServiceContext;
import com.bokesoft.yigo.mid.base.SessionException;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.para.SysPara;
import com.bokesoft.yigo.mid.rsa.RSAMidUtil;
import com.bokesoft.yigo.mid.service.IServiceProcess;
import com.bokesoft.yigo.mid.session.ISessionInfo;
import com.bokesoft.yigo.mid.session.ISessionInfoMap;
import com.bokesoft.yigo.mid.session.SessionInfoProviderHolder;
import com.bokesoft.yigo.struct.env.Env;
import com.bokesoft.yigo.tools.ve.VE;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.json.JSONObject;

public class GuestLogin {
    private String SQL_QUERY_GUEST = null;
    private String userTableName = "USER_Operator";
    protected GuestLoginInfo loginInfo = new GuestLoginInfo();
    protected Long userID = null;
    protected Long operatorID = null;
    protected String name = "";
    protected String passwordFromDB = "";
    protected ISessionLog sessionLog = new SysSessionLog();
    protected IAccountLockoutInfoMap accountLockoutInfoMap = null;

    public GuestLogin(GuestLoginInfo guestLoginInfo) {
        this.loginInfo = guestLoginInfo;
    }

    public GuestLogin(String string, String string2, int n2, long l2, long l3, String string3, String string4, String string5, long l4, Map<String, Object> map, Map<String, String> map2) {
        this.loginInfo.setUser(string);
        this.loginInfo.setPassword(string2);
        this.loginInfo.setMode(n2);
        this.loginInfo.setParas(map);
        this.loginInfo.setTmpClientID(string3);
        this.loginInfo.setValidateCode(string4);
        this.loginInfo.setClientSignedStr(string5);
        this.loginInfo.setTicketID(l4);
    }

    protected void queryUserData(DefaultContext defaultContext) throws Throwable {
        Object object;
        block7: {
            Object object2;
            MetaTable metaTable;
            Object object3;
            if (this.SQL_QUERY_GUEST == null) {
                object3 = defaultContext.getVE().getMetaFactory();
                object = defaultContext.getDBManager();
                metaTable = (MetaTable)object3.getDataObject(this.userTableName).getTableCollection().get(this.userTableName);
                object3 = ((MetaColumn)metaTable.get("Code")).getBindingDBColumnName();
                object2 = ((MetaColumn)metaTable.get("Enable")).getBindingDBColumnName();
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(metaTable.getOIDColumn().getBindingDBColumnName());
                arrayList.add(((MetaColumn)metaTable.get("Password")).getBindingDBColumnName());
                arrayList.add(((MetaColumn)metaTable.get("OperatorID")).getBindingDBColumnName());
                arrayList.add(((MetaColumn)metaTable.get("Name")).getBindingDBColumnName());
                this.SQL_QUERY_GUEST = DBUtil.getQuerySQL((IDBManager)object, arrayList, (MetaTable)metaTable, (String)object2) + " and " + object.keyWordEscape((String)object3) + "=?";
            }
            object3 = defaultContext.getDBManager();
            object = null;
            object2 = null;
            try {
                object = object3.preparedQueryStatement(this.SQL_QUERY_GUEST);
                metaTable = new PSArgs();
                metaTable.addIntArg(Integer.valueOf(1));
                metaTable.addStringArg(this.loginInfo.getUser().toUpperCase());
                object2 = object3.executeQuery((PreparedStatement)object, this.SQL_QUERY_GUEST, (QueryArguments)metaTable);
                if (!object2.next()) {
                    throw new SessionException(1, SessionException.formatMessage((ILocale)defaultContext.getEnv(), (int)1, (Object[])new Object[0]));
                }
                this.userID = object2.getLong(1);
                this.passwordFromDB = object2.getString(2);
                this.operatorID = object2.getLong(3);
                this.name = object2.getString(4);
                if (object2 == null) break block7;
            }
            catch (Throwable throwable) {
                if (object2 != null) {
                    object2.close();
                }
                if (object != null) {
                    object.close();
                }
                throw throwable;
            }
            object2.close();
        }
        if (object != null) {
            object.close();
            return;
        }
    }

    protected void queryRoleData(DefaultContext defaultContext, SessionInfo sessionInfo) throws Throwable {
        new UserRoleUtil().queryRoleData(defaultContext, (ISessionInfo)sessionInfo, this.operatorID);
    }

    protected void securityCheck(DefaultContext defaultContext) throws Throwable {
        ServerSetting serverSetting = ServerSetting.getInstance();
        if (serverSetting.containsValidateLevel(6) && (long)SessionTicketidRecorder.getTicketID((String)this.loginInfo.getTmpClientID()) != this.loginInfo.getTicketID()) {
            throw new CertificateException(8, "Error connect!");
        }
        if ((serverSetting.containsValidateLevel(3) || serverSetting.containsValidateLevel(4)) && UserInfoUtil.getUserInfo(defaultContext, this.loginInfo.getUser()) != null && !TypeConvertor.toBoolean((Object)new CheckCertificateCmd(this.operatorID, this.loginInfo.getMode(), this.loginInfo.getClientSignedStr()).doCmd(defaultContext)).booleanValue()) {
            throw new CertificateException(1, "Certificate not found or expired!");
        }
    }

    public Object doLogin(DefaultContext defaultContext) throws Throwable {
        this.checkValidateCode(defaultContext);
        this.queryUserData(defaultContext);
        this.securityCheck(defaultContext);
        return this.login(defaultContext);
    }

    protected void checkValidateCode(DefaultContext defaultContext) {
        ISessionInfo iSessionInfo;
        if (ServerSetting.getInstance().containsValidateLevel(1) && ((iSessionInfo = SessionInfoProviderHolder.getProvider((int)0).getSessionInfoMap().get(this.loginInfo.getTmpClientID())) == null || !iSessionInfo.getValidateCode().equalsIgnoreCase(this.loginInfo.getValidateCode()))) {
            throw new SessionException(8, SessionException.formatMessage((ILocale)defaultContext.getEnv(), (int)8, (Object[])new Object[0]));
        }
    }

    private JSONObject login(DefaultContext defaultContext) throws Throwable {
        String string;
        MetaSession metaSession;
        MetaSession metaSession2;
        String string2;
        this.accountLockoutInfoMap = AccountLockoutInfoProvider.getInstance().getAccountLockoutInfoMap();
        int n2 = this.loginInfo.getMode() == -1 ? 2 : this.loginInfo.getMode();
        ISessionInfoMap iSessionInfoMap = SessionInfoProviderHolder.getProvider((int)n2).getSessionInfoMap();
        IMetaFactory iMetaFactory = defaultContext.getVE().getMetaFactory();
        Env env = defaultContext.getVE().getEnv();
        JSONObject jSONObject = new JSONObject();
        String string3 = env.getClientID();
        SessionInfo sessionInfo = new SessionInfo();
        sessionInfo.setClientID(string3);
        sessionInfo.setOperatorID(this.operatorID);
        sessionInfo.setUserOperatorID(this.userID);
        sessionInfo.setIP(env.getClientIP());
        sessionInfo.setLoginTime(new Date());
        sessionInfo.setLastActiveTime(new Date());
        sessionInfo.setMode(n2);
        sessionInfo.setGuestUserID(this.userID);
        sessionInfo.setGuestLogin(true);
        sessionInfo.setSessionParas(this.loginInfo.getParas());
        env.setSessionParas(this.loginInfo.getParas());
        this.queryRoleData(defaultContext, sessionInfo);
        try {
            this.accountLockoutInfoMap.autoUnlock(defaultContext, (ISessionInfo)sessionInfo);
            this.accountLockoutInfoMap.check(defaultContext, (ISessionInfo)sessionInfo);
            this.passwordCheck(defaultContext);
        }
        catch (CoreException coreException) {
            this.sessionLog.logErr(defaultContext, -2, coreException.getMessage());
            throw coreException;
        }
        if (SvrInfo.guestKick()) {
            ISessionInfo object2;
            string2 = AuthUtil.getLoginInfo((int)n2, (long)this.userID);
            if (string2 != null && !string2.isEmpty() && (object2 = iSessionInfoMap.get(string2)) != null && object2.getGuestUserID() != -1L) {
                iSessionInfoMap.remove(string2);
                AuthUtil.putKickInfo((String)(this.userID + "@" + string2), (String)string2);
            }
            AuthUtil.putLoginInfo((int)n2, (long)this.userID, (String)string3);
        }
        env.setGuestUserID(this.userID.longValue());
        env.setUserID(this.operatorID);
        env.setUserCode(this.loginInfo.getUser());
        env.setUserName(this.name);
        string2 = iMetaFactory.getSetting();
        if (string2 != null && (metaSession2 = string2.getSession()) != null && metaSession2.isSessionParaAsCluster()) {
            long l2 = TypeConvertor.toLong((Object)this.loginInfo.getParas().get(metaSession2.getSessionParaKey()));
            env.setClusterid(l2);
            sessionInfo.setClusterID(l2);
        }
        jSONObject.put("clientID", (Object)string3);
        jSONObject.put("UserID", (Object)this.userID);
        jSONObject.put("Time", sessionInfo.getLoginTime().getTime());
        jSONObject.put("Name", (Object)this.name);
        MetaSetting metaSetting = defaultContext.getVE().getMetaFactory().getSetting();
        if (metaSetting != null && (metaSession = metaSetting.getSession()) != null && (string = metaSession.getSessionParaProcess()) != null && !string.isEmpty()) {
            for (String string4 : string.split(";")) {
                IServiceProcess iServiceProcess;
                if (string4.isEmpty() || (iServiceProcess = (IServiceProcess)ReflectHelper.newInstance((VE)defaultContext.getVE(), (String)string4)) == null) continue;
                iServiceProcess.process((IServiceContext)defaultContext);
            }
        }
        Map map = env.getSessionParas();
        sessionInfo.setSessionParas(env.getSessionParas());
        iSessionInfoMap.put(string3, (ISessionInfo)sessionInfo);
        this.sessionLog.logLogin(defaultContext, (ISessionInfo)sessionInfo);
        int n3 = this.accountLockoutInfoMap.log(defaultContext, this.operatorID.longValue(), sessionInfo.getMode(), 0);
        LoginUtil.removeTempSessionInfo(this.loginInfo.getTmpClientID());
        jSONObject.put("SessionParas", (Object)(map == null ? "" : JSONUtil.toJSON((Map)map)));
        jSONObject.put("LoginCount", n3);
        this.postLogin(defaultContext);
        return jSONObject;
    }

    protected void passwordCheck(DefaultContext defaultContext) throws Throwable {
        String string = RSAMidUtil.decryptByPrivate((String)SysPara.getInstance().get("PrivateKey"), (String)this.passwordFromDB);
        String string2 = this.loginInfo.getPassword();
        MidPasswordRuleChecker.getInstance().checkLoginRule(string2, defaultContext.getVE().getEnv().getLocale(), (Object)defaultContext);
        if (!string2.equals(string)) {
            LoginUtil.recordLoginFailed(this.loginInfo.getTmpClientID());
            this.sessionLog.logErr(defaultContext, 1, "");
            this.accountLockoutInfoMap.log(defaultContext, this.operatorID.longValue(), this.loginInfo.getMode(), 1);
            throw new SessionException(1, SessionException.formatMessage((ILocale)defaultContext.getEnv(), (int)1, (Object[])new Object[0]));
        }
    }

    protected void postLogin(DefaultContext defaultContext) throws Throwable {
    }

    public void setUserTableName(String string) {
        this.userTableName = string;
    }
}

