/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.report.print.chart;

import com.bokesoft.yes.report.output.OutputEmbedChart;
import com.bokesoft.yigo.common.def.ChartType;
import com.bokesoft.yigo.report.print.chart.builder.IChartBuilder;
import com.bokesoft.yigo.report.print.chart.builder.impl.AreaBuilder;
import com.bokesoft.yigo.report.print.chart.builder.impl.HBarBuilder;
import com.bokesoft.yigo.report.print.chart.builder.impl.LineBuilder;
import com.bokesoft.yigo.report.print.chart.builder.impl.PieBuilder;
import com.bokesoft.yigo.report.print.chart.builder.impl.ScatterBuilder;
import com.bokesoft.yigo.report.print.chart.builder.impl.StackedHBarBuilder;
import com.bokesoft.yigo.report.print.chart.builder.impl.StackedVBarBuilder;
import com.bokesoft.yigo.report.print.chart.builder.impl.VBarBuilder;
import java.util.HashMap;
import org.jfree.chart.JFreeChart;

public abstract class ReportChartFactory {
    private static HashMap<String, IChartBuilder> mapChartBuilderFactory = new HashMap<String, VBarBuilder>();

    public static JFreeChart createChart(OutputEmbedChart outputEmbedChart) {
        String string = ChartType.toString((int)outputEmbedChart.getChartType());
        return mapChartBuilderFactory.get(string).build(outputEmbedChart);
    }

    public static JFreeChart createChartDemo(int n) {
        String string = ChartType.toString((int)n);
        return mapChartBuilderFactory.get(string).buildDemo();
    }

    static {
        mapChartBuilderFactory.put("VBar", new VBarBuilder());
        mapChartBuilderFactory.put("StackedVBar", new StackedVBarBuilder());
        mapChartBuilderFactory.put("HBar", new HBarBuilder());
        mapChartBuilderFactory.put("StackedHBar", new StackedHBarBuilder());
        mapChartBuilderFactory.put("Area", new AreaBuilder());
        mapChartBuilderFactory.put("Line", new LineBuilder());
        mapChartBuilderFactory.put("Scatter", new ScatterBuilder());
        mapChartBuilderFactory.put("Pie", new PieBuilder());
    }
}

