/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.report.print.transform;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.report.output.OutputCell;
import com.bokesoft.yes.report.output.OutputColumn;
import com.bokesoft.yes.report.output.OutputEmbed;
import com.bokesoft.yes.report.output.OutputEmbedObject;
import com.bokesoft.yes.report.output.OutputGrid;
import com.bokesoft.yes.report.output.OutputPage;
import com.bokesoft.yes.report.output.OutputPageSet;
import com.bokesoft.yes.report.output.OutputRow;
import com.bokesoft.yes.report.output.OutputSection;
import com.bokesoft.yes.report.print.IUnitTrans;
import com.bokesoft.yes.report.print.paper.IPrintPaper;
import com.bokesoft.yes.report.print.paper.PrintPaperWorker;
import com.bokesoft.yes.report.print.transform.ICellExport;
import com.bokesoft.yes.report.print.transform.IEmbedExport;
import com.bokesoft.yes.report.print.transform.IPageExport;
import com.bokesoft.yes.report.print.transform.IReportExport;
import com.bokesoft.yes.report.print.transform.ISectionExport;
import com.bokesoft.yes.report.print.transform.ITransformContext;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ReportTransform<C extends ITransformContext> {
    private IReportExport<C> export = null;
    private IUnitTrans unitTrans = null;
    private IPageExport<C> pageExport = null;
    private ISectionExport sectionExport = null;
    private ICellExport<C> cellExport = null;
    private IEmbedExport<C> embedExport = null;
    public Map<String, Map<Integer, String>> map = new HashMap<String, Map<Integer, String>>();

    public ReportTransform(IReportExport<C> iReportExport) {
        this.export = iReportExport;
        this.unitTrans = iReportExport.getUnitTrans();
        this.pageExport = iReportExport.getPageExport();
        this.sectionExport = iReportExport.getSectionExport();
        this.cellExport = iReportExport.getCellExport();
        this.embedExport = iReportExport.getEmbedExport();
    }

    public void export(C c, OutputPageSet outputPageSet, int n, int n2) {
        PrintPaperWorker printPaperWorker = new PrintPaperWorker();
        printPaperWorker.preparePapers(outputPageSet, n, n2);
        this.export(c, printPaperWorker);
    }

    public void export(C c, PrintPaperWorker printPaperWorker) {
        printPaperWorker.doPaperAction(iPrintPaper -> this.exportPaper(c, -1, iPrintPaper));
        try {
            this.export.export((ITransformContext)c);
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void export(C c, IPrintPaper iPrintPaper) {
        this.exportPaper(c, -1, iPrintPaper);
    }

    private void exportPaper(C c, int n, IPrintPaper object) {
        this.export.preparePaper(c, n, (IPrintPaper)object);
        n = 0;
        OutputPageSet outputPageSet = object.getPageSet();
        for (int i = 0; i < outputPageSet.size(); ++i) {
            object = outputPageSet.get(i);
            this.exportPage(c, (OutputPage)object, n);
            n += this.getPageOrientationHeight((OutputPage)object);
        }
    }

    private int getPageOrientationHeight(OutputPage outputPage) {
        if (outputPage.getPaperOrientation() == 0) {
            return outputPage.getPageHeight();
        }
        return outputPage.getPageWidth();
    }

    private void exportPage(C c, OutputPage outputPage, int n) {
        Object object;
        int n2 = this.unitTrans.transSize(outputPage.getTopMargin());
        OutputGrid outputGrid = outputPage.getGrid();
        this.pageExport.preExport(c, outputPage, n);
        this.pageExport.export(c, outputPage, n);
        int n3 = n;
        int n4 = outputGrid.size();
        for (int i = 0; i < n4; ++i) {
            object = outputGrid.get(i);
            if (!((OutputSection)object).isFlowTop()) continue;
            n3 += this.exportSection(c, outputPage, (OutputSection)object, n2, n3, true);
        }
        n3 = this.getPageOrientationHeight(outputPage) - outputPage.getTopMargin() - outputPage.getBottomMargin() + n;
        for (n4 = outputGrid.size() - 1; n4 >= 0; --n4) {
            object = outputGrid.get(n4);
            if (((OutputSection)object).isFlowTop()) continue;
            n3 -= this.exportSection(c, outputPage, (OutputSection)object, n2, n3, false);
        }
        OutputEmbed outputEmbed = outputPage.getEmbed();
        if (outputEmbed != null) {
            Iterator<OutputEmbedObject> iterator = outputEmbed.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                n2 = this.unitTrans.transSize(((OutputEmbedObject)object).getX());
                int n5 = this.unitTrans.transSize(((OutputEmbedObject)object).getY() + n);
                n3 = this.unitTrans.transSize(((OutputEmbedObject)object).getWidth());
                int n6 = this.unitTrans.transSize(((OutputEmbedObject)object).getHeight());
                this.embedExport.export(c, (OutputEmbedObject)object, n2, n5, n3, n6);
            }
        }
        this.pageExport.postExport(c, outputPage, n);
    }

    /*
     * WARNING - void declaration
     */
    private void calcSectionMetrics(OutputSection outputSection, boolean bl, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n3;
        int n4;
        int n5 = outputSection.getRowCount();
        if (bl) {
            for (n4 = 0; n4 < n5; ++n4) {
                int n6 = outputSection.getRow(n4).getHeight();
                var5_9[n4] = n3;
                var7_11[n4] = this.unitTrans.transSize(n3 += n6);
            }
        } else {
            for (n4 = n5 - 1; n4 >= 0; --n4) {
                int n7 = outputSection.getRow(n4).getHeight();
                var7_11[n4] = this.unitTrans.transSize(n3);
                var5_9[n4] = n3 - n7;
                n3 -= n7;
            }
        }
        n4 = outputSection.getColumnCount();
        for (n3 = 0; n3 < n4; ++n3) {
            void var3_7;
            int n8 = outputSection.getColumn(n3).getWidth();
            var6_10[n3] = var3_7;
            var8_12[n3] = this.unitTrans.transSize((int)(var3_7 += n8));
        }
    }

    private boolean checkMergeVisible(OutputSection outputSection, int n, int n2) {
        boolean bl = false;
        while (n <= n2) {
            if (outputSection.getColumn(n).isVisible()) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private boolean inRange(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        n = Math.max(n, n5);
        n2 = Math.max(n2, n6);
        n3 = Math.min(n3, n7);
        n4 = Math.min(n4, n8);
        return n <= n3 && n2 <= n4;
    }

    private int exportSection(C c, OutputPage outputPage, OutputSection outputSection, int n, int n2, boolean n3) {
        int n4 = 0;
        int n5 = outputSection.getColumnCount();
        int n6 = outputSection.getRowCount();
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n5];
        int[] nArray3 = new int[n6];
        int[] nArray4 = new int[n5];
        int n7 = this.unitTrans.transSize(outputPage.getLeftMargin());
        this.calcSectionMetrics(outputSection, n3 != 0, 0, n2, nArray, nArray2, nArray3, nArray4);
        int n8 = 0;
        int n9 = n6 - 1;
        int n10 = 0;
        int n11 = n5 - 1;
        boolean bl = outputSection.isForceClip();
        n2 = bl ? 1 : 0;
        if (bl) {
            n8 = Math.max(0, outputSection.getTopIndex());
            n9 = Math.min(n9, outputSection.getBottomIndex());
            n10 = Math.max(0, outputSection.getLeftIndex());
            n11 = Math.min(n11, outputSection.getRightIndex());
        }
        int n12 = 0;
        int n13 = 0;
        if (n2 != 0) {
            Object object;
            int n14;
            for (n14 = 0; n14 < n8; ++n14) {
                object = outputSection.getRow(n14);
                n13 += ((OutputRow)object).getHeight();
            }
            n13 = -this.unitTrans.transSize(n13);
            for (n14 = 0; n14 < n10; ++n14) {
                object = outputSection.getColumn(n14);
                n12 += ((OutputColumn)object).getWidth();
            }
            n12 = -this.unitTrans.transSize(n12);
        }
        boolean[] blArray = new boolean[n6];
        for (int i = 0; i < n6; ++i) {
            if (n2 != 0) {
                int n15 = i;
                blArray[n15] = n15 >= n8 && i <= n9;
                continue;
            }
            blArray[i] = true;
        }
        boolean[] blArray2 = new boolean[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            if (n2 != 0) {
                int n16 = n3;
                blArray2[n16] = n16 >= n10 && n3 <= n11;
                continue;
            }
            blArray2[n3] = true;
        }
        for (int i = 0; i < n6; ++i) {
            OutputRow outputRow = outputSection.getRow(i);
            n2 = outputRow.getHeight();
            for (int j = 0; j < n5; ++j) {
                String string;
                String string2;
                Object object;
                Object object2;
                int n17;
                boolean bl2;
                int n18;
                int n19;
                OutputColumn outputColumn = outputSection.getColumn(j);
                OutputCell outputCell = outputRow.get(j);
                if (blArray[i] && blArray2[j]) {
                    n3 = !outputCell.isMerged() || outputCell.isMergedHead() ? 1 : 0;
                } else {
                    n3 = 0;
                    if (outputCell.isMerged() && outputCell.isMergedHead() && this.inRange(j, i, n19 = j + outputCell.getMergedColumnSpan() - 1, n18 = i + outputCell.getMergedRowSpan() - 1, n10, n8, n11, n9)) {
                        n3 = 1;
                    }
                }
                if (n3 != 0) {
                    int n20;
                    bl2 = true;
                    n3 = nArray2[j];
                    n17 = nArray[i];
                    if (outputCell.isMerged()) {
                        n19 = j + outputCell.getMergedColumnSpan() - 1;
                        n18 = i + outputCell.getMergedRowSpan() - 1;
                        if (n19 >= n5) {
                            n19 = n5 - 1;
                        }
                        if (n18 >= n6) {
                            int n21 = n18;
                            n18 = n6 - 1;
                            object2 = StringUtil.strcat((Object[])new Object[]{outputPage.getPageIndex() + 1, ":", j + 1});
                            int n22 = i > 0 ? n6 - i : n6;
                            object = new HashMap();
                            Integer n23 = i > 0 ? outputCell.getMergedRowSpan() - (n6 - (i + 1)) : n21 - n18;
                            Integer n24 = outputCell.getMergedColumnSpan();
                            String string3 = StringUtil.strcat((Object[])new Object[]{n23, ":", n24, ":", outputCell.getMergedRowSpan()});
                            ((HashMap)object).put(n22, string3);
                            this.map.put((String)object2, (Map<Integer, String>)object);
                        }
                        n20 = nArray4[n19];
                        n18 = nArray3[n18];
                        if (!outputColumn.isVisible()) {
                            bl2 = this.checkMergeVisible(outputSection, j, n19);
                        }
                    } else {
                        n20 = nArray4[j];
                        n18 = nArray3[i];
                        if (!outputColumn.isVisible()) {
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    n3 = this.unitTrans.transSize(n3);
                    n17 = this.unitTrans.transSize(n17);
                    n20 -= n3;
                    n18 -= n17;
                    this.cellExport.export(c, outputRow, outputCell, n7, n, n3 += n12, n17 += n13, n20, n18);
                    continue;
                }
                if (!outputCell.isMerged() || (object2 = this.map.get(string2 = StringUtil.strcat((Object[])new Object[]{outputPage.getPageIndex(), ":", j + 1}))) == null || object2.size() <= 0 || StringUtil.isBlankOrNull((String)(string = object2.get(outputCell.getMergedRowSpan())))) continue;
                object = string.split(":");
                int n25 = TypeConvertor.toInteger((Object)object[0]);
                int n26 = TypeConvertor.toInteger((Object)object[1]);
                int n27 = TypeConvertor.toInteger((Object)object[2]);
                outputCell.setText("");
                bl2 = true;
                n3 = nArray2[j];
                n17 = nArray[i];
                n19 = j + n26 - 1;
                n18 = i + n25 - 1;
                if (n19 >= n5) {
                    n19 = n5 - 1;
                }
                if (n18 >= n6) {
                    n25 = n18;
                    n18 = n6 - 1;
                    object2 = StringUtil.strcat((Object[])new Object[]{outputPage.getPageIndex() + 1, ":", j + 1});
                    int n28 = n27 - outputCell.getMergedRowSpan() > n6 ? outputCell.getMergedRowSpan() + n6 : outputCell.getMergedRowSpan() - (n25 - n18);
                    object = new HashMap();
                    Object object3 = n27 - outputCell.getMergedRowSpan() > n6 ? n27 - outputCell.getMergedRowSpan() - n6 : n25 - n18;
                    object3 = StringUtil.strcat((Object[])new Object[]{object3, ":", n26, ":", n27});
                    ((HashMap)object).put(n28, object3);
                    this.map.put((String)object2, (Map<Integer, String>)object);
                }
                int n29 = nArray4[n19];
                n18 = nArray3[n18];
                if (!outputColumn.isVisible()) {
                    bl2 = this.checkMergeVisible(outputSection, j, n19);
                }
                if (!bl2) continue;
                n3 = this.unitTrans.transSize(n3);
                n17 = this.unitTrans.transSize(n17);
                n29 -= n3;
                n18 -= n17;
                this.cellExport.export(c, outputRow, outputCell, n7, n, n3 += n12, n17 += n13, n29, n18);
            }
            n4 += n2;
        }
        return n4;
    }
}

