/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.report.print.g2dexport;

import com.bokesoft.yes.common.util.StringUtil;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.j2se.MatrixToImageWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class MatrixToImageUtil {
    public static BufferedImage text2Barcode(String string, int n, int n2, String string2, String string3, String string4, int n3) throws Exception {
        return MatrixToImageWriter.toBufferedImage((BitMatrix)MatrixToImageUtil.generateBitMatrix(string, n, n2, string2, string3, string4, n3));
    }

    public static InputStream text2BarCode(String object, int n, int n2, String string, String string2, String string3, int n3) throws Exception {
        object = MatrixToImageUtil.generateBitMatrix((String)object, n, n2, string, string2, string3, n3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)object, (String)"png", (OutputStream)byteArrayOutputStream);
        object = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        byteArrayOutputStream.close();
        return object;
    }

    private static BitMatrix generateBitMatrix(String string, int n, int n2, String string2, String string3, String string4, int n3) throws Exception {
        HashMap<EncodeHintType, Object> hashMap = new HashMap<EncodeHintType, Object>();
        if (StringUtil.isBlankOrNull((String)string3)) {
            string3 = "UTF-8";
        }
        hashMap.put(EncodeHintType.CHARACTER_SET, string3);
        hashMap.put(EncodeHintType.MARGIN, n3);
        string2 = BarcodeFormat.valueOf((String)string2);
        MatrixToImageUtil.prepareErrorCorrectionLevel((BarcodeFormat)string2, string4, hashMap);
        if (BarcodeFormat.QR_CODE == string2) {
            n2 = (n2 = Math.min(n, n2)) < 50 ? 50 : n2;
            n = n2;
        }
        return new MultiFormatWriter().encode(string, (BarcodeFormat)string2, n, n2, hashMap);
    }

    private static void prepareErrorCorrectionLevel(BarcodeFormat barcodeFormat, String string, Map<EncodeHintType, Object> map) {
        switch (barcodeFormat) {
            case QR_CODE: {
                MatrixToImageUtil.prepareErrorCorrectionLevel4QR_Code(string, map);
                return;
            }
            case PDF_417: {
                MatrixToImageUtil.prepareErrorCorrectionLevel4PDF_417(string, map);
            }
        }
    }

    private static void prepareErrorCorrectionLevel4QR_Code(String string, Map<EncodeHintType, Object> map) {
        if (StringUtil.isBlankOrNull((String)string)) {
            string = "H";
        }
        string = ErrorCorrectionLevel.valueOf((String)string.toUpperCase());
        map.put(EncodeHintType.ERROR_CORRECTION, string);
    }

    private static void prepareErrorCorrectionLevel4PDF_417(String string, Map<EncodeHintType, Object> map) {
        if (StringUtil.isBlankOrNull((String)string)) {
            return;
        }
        int n = MatrixToImageUtil.parseErrorCorrectionLevel2Int(ErrorCorrectionLevel.valueOf((String)string.toUpperCase()));
        map.put(EncodeHintType.ERROR_CORRECTION, n);
    }

    private static int parseErrorCorrectionLevel2Int(ErrorCorrectionLevel errorCorrectionLevel) {
        switch (errorCorrectionLevel) {
            case H: {
                return 5;
            }
            case Q: {
                return 4;
            }
            case M: {
                return 3;
            }
            case L: {
                return 2;
            }
        }
        return 0;
    }
}

