package com.bokesoft.yigo.parser;

import com.bokesoft.yes.parser.LexDef;
import com.bokesoft.yes.parser.Lexer;

public class LexerUtil {
	
	/**
	 * 解析出表达式中的依赖字段,通过回调进行验证
	 * @param content 表达式内容
	 * @param validater 验证
	 * @return 依赖字段,以","分割,如A,B,C
	 * @throws Throwable 词法异常
	 */
	public static String recognize(String content, Validater validater) throws Throwable {
		Lexer lex = new Lexer();
		lex.setContent(content);
		
		StringBuffer sb = new StringBuffer();
		int lexID = lex.next();
		while (lexID != -1) {
			if ( lexID == LexDef.ID || lexID == LexDef.CONST ) {
				String v = lex.getLexValue();
				if( v != null && !v.trim().isEmpty() ) {
					if( validater != null ) {
						if( validater.validate(v) ) {
							sb.append(v).append(",");
						}
					} else {
						sb.append(v).append(",");
					}
				}
			}
			lexID = lex.next();
		}
		if( sb.length() > 0 ) {
			sb.deleteCharAt(sb.length() - 1);
		}
		return sb.toString();
	}
	
	public static void main(String[] args) throws Throwable {
		System.out.println(LexerUtil.recognize("Sum('G14:G28')", new Validater() {
			
			@Override
			public boolean validate(String id) {
				return true;
			}
		}));
	}
}
