/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.init;

import com.bokesoft.yes.base.IStartListener;
import com.bokesoft.yes.bpm.schema.BPMSchemaProvider;
import com.bokesoft.yes.init.SystemDataMaintance;
import com.bokesoft.yes.mid.base.ServerSetting;
import com.bokesoft.yes.mid.bgtask.BackgroundTaskTableDataObjectCreator;
import com.bokesoft.yes.mid.cmd.config.VariantTableDataObjectCreator;
import com.bokesoft.yes.mid.scheduler.QuartzTableDataObjectCreator;
import com.bokesoft.yes.mid.schema.DefaultSchemaProvider;
import com.bokesoft.yes.mid.schema.ISchemaProvider;
import com.bokesoft.yes.mid.schema.maintance.DBMaintanceFactory;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.bpm.total.BPMDataObjectCreater;
import com.bokesoft.yigo.meta.dataobject.MessageDataObjectCreator;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.dataobject.SystemTableDataObjectCreater;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.midsetting.MetaDataObjectProvider;
import com.bokesoft.yigo.meta.midsetting.MetaMidSetting;
import com.bokesoft.yigo.meta.midsetting.MetaSchemaProvider;
import com.bokesoft.yigo.meta.setting.MetaBPMSetting;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.meta.taskflow.TaskFlowDataObjectCreator;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.base.IDataObjectProvider;
import com.bokesoft.yigo.mid.para.SysPara;
import java.util.Iterator;

public class DBMaintainceListener
implements IStartListener {
    @Override
    public void invoke(DefaultContext context) throws Throwable {
        if (context.getVE().getDSN() == null) {
            return;
        }
        ServerSetting serverSetting = ServerSetting.getInstance();
        DBMaintainceListener.initSystemDataObjects(context);
        if (serverSetting.isMaster()) {
            MetaBPMSetting setting;
            IMetaFactory fc = context.getVE().getMetaFactory();
            MetaSetting solutionSetting = fc.getSetting();
            MetaBPMSetting metaBPMSetting = setting = solutionSetting != null ? solutionSetting.getBPMSetting() : null;
            if (setting != null && setting.getRecordFormRights().booleanValue()) {
                DBMaintanceFactory.getInstance().maintance((ISchemaProvider)new BPMSchemaProvider(context), context.getDBManager());
            }
            DefaultSchemaProvider schemaProvider = new DefaultSchemaProvider(context, serverSetting.getDeploy());
            DBMaintanceFactory.getInstance().maintance((ISchemaProvider)schemaProvider, context.getDBManager());
            SystemDataMaintance sysDataMaintance = new SystemDataMaintance(context, (ISchemaProvider)schemaProvider);
            sysDataMaintance.maintain();
        } else {
            SysPara.getInstance().init(context.getDBManager());
        }
    }

    public static void initSystemDataObjects(DefaultContext context) throws Throwable {
        MetaSchemaProvider schemaProvider;
        MetaMidSetting allMidSetting;
        IMetaFactory fc = context.getVE().getMetaFactory();
        MetaDataObjectList dataObjectList = fc.getDataObjectList();
        for (int i = 0; i < dataObjectList.size(); ++i) {
            MetaDataObjectProfile dataObjectProfile = (MetaDataObjectProfile)dataObjectList.get(i);
            String profileKey = dataObjectProfile.getKey();
            MetaDataObject dataObject = dataObjectProfile.getDataObject();
            if (dataObject == null || dataObject.isMaintainSchema().booleanValue()) continue;
            dataObjectList.remove(profileKey);
            --i;
        }
        DBMaintainceListener.addMetaDataObject(fc, BPMDataObjectCreater.getBPMDataObject((IMetaFactory)fc));
        DBMaintainceListener.addMetaDataObject(fc, BPMDataObjectCreater.getWorkitemDataObject());
        DBMaintainceListener.addMetaDataObject(fc, SystemTableDataObjectCreater.getSystemTableDataObject());
        DBMaintainceListener.addMetaDataObject(fc, QuartzTableDataObjectCreator.getQuartzTableDataObject());
        DBMaintainceListener.addMetaDataObject(fc, BackgroundTaskTableDataObjectCreator.getBackgroundTaskTableDataObject());
        DBMaintainceListener.addMetaDataObject(fc, TaskFlowDataObjectCreator.getDataObject());
        MetaSetting metaSetting = context.getVE().getMetaFactory().getSetting();
        if (metaSetting != null && metaSetting.isMessageEnabled().booleanValue()) {
            DBMaintainceListener.addMetaDataObject(fc, MessageDataObjectCreator.getProducerMessageDataObject());
            DBMaintainceListener.addMetaDataObject(fc, MessageDataObjectCreator.getConsumerMessageDataObject());
        }
        if (ServerSetting.getInstance().isUseVariant()) {
            DBMaintainceListener.addMetaDataObject(fc, VariantTableDataObjectCreator.getVariantTableDataObject());
        }
        if ((allMidSetting = fc.getMidSetting()) != null && (schemaProvider = allMidSetting.getSchemaProvider()) != null) {
            Iterator it = schemaProvider.iterator();
            MetaDataObjectProvider p = null;
            while (it.hasNext()) {
                p = (MetaDataObjectProvider)it.next();
                String impl = p.getImpl();
                Class<?> implClass = Class.forName(impl);
                IDataObjectProvider ins = (IDataObjectProvider)implClass.newInstance();
                MetaDataObject dataObject = ins.create(context);
                DBMaintainceListener.addMetaDataObject(fc, dataObject);
            }
        }
    }

    private static void addMetaDataObject(IMetaFactory metaFactory, MetaDataObject dataObject) throws Throwable {
        MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
        if (dataObject.isMaintainSchema().booleanValue() && !dataObjectList.containsKey(dataObject.getKey())) {
            MetaDataObjectProfile profile = new MetaDataObjectProfile();
            profile.setKey(dataObject.getKey());
            profile.setDataObject(dataObject);
            profile.setCaption(dataObject.getCaption());
            profile.setSecondaryType(dataObject.getSecondaryType());
            dataObjectList.add((KeyPairMetaObject)profile);
        }
    }
}

