/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.init;

import com.bokesoft.yes.base.MidAppException;
import com.bokesoft.yes.bpm.BPMMidFunction.BPMMidFunctionProvider;
import com.bokesoft.yes.bpm.schema.BPMSchemaProxyFactory;
import com.bokesoft.yes.bpm.schema.DefaultBPMSchemaProxyFactory;
import com.bokesoft.yes.bpm.schema.IBPMSchemaProxyFactory;
import com.bokesoft.yes.bpm.service.BPMDataMigrationFactory;
import com.bokesoft.yes.bpm.service.KillInstancesFactory;
import com.bokesoft.yes.bpm.service.LoadBPMFactory;
import com.bokesoft.yes.bpm.service.SaveBPMDataMapFactory;
import com.bokesoft.yes.bpm.timer.EvictExpiredDelegateJob;
import com.bokesoft.yes.bpm.timer.ExecTimeoutItemJob;
import com.bokesoft.yes.common.encrypt.RSA;
import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.util.Base64;
import com.bokesoft.yes.common.util.ReflectUtil;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.datamap.function.DocumentFunctionProvider;
import com.bokesoft.yes.design.function.DesignMidFunctionProvider;
import com.bokesoft.yes.dsn.DefaultDSNFactory;
import com.bokesoft.yes.excel.parser.ExcelMidFunctionProvider;
import com.bokesoft.yes.i18n.StringTable;
import com.bokesoft.yes.init.DBMaintainceListener;
import com.bokesoft.yes.init.PreLoadProcessInDB;
import com.bokesoft.yes.log.NullLogSvr;
import com.bokesoft.yes.log.log4j.LogSvrImpl;
import com.bokesoft.yes.meta.persist.dom.deploy.MetaDeployLoad;
import com.bokesoft.yes.mid.auth.cache.simple.MobileSessionInfoProvider;
import com.bokesoft.yes.mid.auth.cache.simple.OvertimeSessionInfoProvider;
import com.bokesoft.yes.mid.auth.cache.simple.SimpleSessionInfoProvider;
import com.bokesoft.yes.mid.auth.cache.simple.TempSessionInfoProvider;
import com.bokesoft.yes.mid.authority.AuthorityProvider;
import com.bokesoft.yes.mid.authority.AuthorityProviderFactory;
import com.bokesoft.yes.mid.authority.IAuthorityProvider;
import com.bokesoft.yes.mid.authority.IStructuredAuthorityProvider;
import com.bokesoft.yes.mid.backgroundtask.BackgroundTask;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.base.DBDSNItem;
import com.bokesoft.yes.mid.base.DSNItem;
import com.bokesoft.yes.mid.base.DSNItemCollection;
import com.bokesoft.yes.mid.base.DefaultMidVEFactory;
import com.bokesoft.yes.mid.base.MidGlobalEnv;
import com.bokesoft.yes.mid.base.ServerSetting;
import com.bokesoft.yes.mid.base.SvrInfo;
import com.bokesoft.yes.mid.base.VariantSetting;
import com.bokesoft.yes.mid.dict.DictCacheProxyFactory;
import com.bokesoft.yes.mid.dict.DictMaintainScheduleJob;
import com.bokesoft.yes.mid.dict.DictTreeServiceProxyFactory;
import com.bokesoft.yes.mid.dict.IDictCacheProxyFactory;
import com.bokesoft.yes.mid.dict.IDictTreeServiceProxyFactory;
import com.bokesoft.yes.mid.dict.MidDictItemCacheFactory;
import com.bokesoft.yes.mid.dict.proxy.MidDictCacheProxyFactory;
import com.bokesoft.yes.mid.dict.proxy.MidDictTreeServiceProxyFactory;
import com.bokesoft.yes.mid.dsn.DSNFactory;
import com.bokesoft.yes.mid.function.MidFunctionProvider;
import com.bokesoft.yes.mid.hotdeploy.MidEnvManager;
import com.bokesoft.yes.mid.hotdeploy.MidGlobalEnvState;
import com.bokesoft.yes.mid.oid.OIDAllocatorFactory;
import com.bokesoft.yes.mid.oid.impl.MidOIDAllocatorFactory;
import com.bokesoft.yes.mid.parser.MidFunctionImplMap;
import com.bokesoft.yes.mid.redis.RedisCacheFactory;
import com.bokesoft.yes.mid.redis.RedisConnectionFactory;
import com.bokesoft.yes.mid.right.FormRightsProxyFactory;
import com.bokesoft.yes.mid.rights.IFormRightsProxyFactory;
import com.bokesoft.yes.mid.rights.IRightsProviderFactory;
import com.bokesoft.yes.mid.rights.MidUserRightsFactory;
import com.bokesoft.yes.mid.rights.RightsProviderFactory;
import com.bokesoft.yes.mid.scheduler.job.EvictExpiredSessionJob;
import com.bokesoft.yes.mid.schemamgr.MidSchemaCheckFactory;
import com.bokesoft.yes.mid.schemamgr.MidSchemaCreateFactory;
import com.bokesoft.yes.mid.service.MidProcessFlowHandler;
import com.bokesoft.yes.mid.service.datamap.DataMapLogicCheckFactory;
import com.bokesoft.yes.mid.servicerights.DefaultServiceRightCheckerFactory;
import com.bokesoft.yes.mid.session.AccountLockoutInfoProvider;
import com.bokesoft.yes.mid.session.IAccountLockoutInfoMap;
import com.bokesoft.yes.mid.simple.SimpleCacheFactory;
import com.bokesoft.yes.mid.util.PropertyUtil;
import com.bokesoft.yes.rights.DefaultFormRightsProxyFactory;
import com.bokesoft.yes.struct.document.DocumentFunctionMap;
import com.bokesoft.yes.tools.dic.item.DictItemCacheFactory;
import com.bokesoft.yes.tools.dic.item.IDictItemCacheFactory;
import com.bokesoft.yes.tools.env.ResolverProfile;
import com.bokesoft.yes.tools.lock.ILock;
import com.bokesoft.yes.tools.lock.LockFactory;
import com.bokesoft.yes.tools.util.ReflectHelper;
import com.bokesoft.yigo.cache.CacheFactory;
import com.bokesoft.yigo.cache.ICacheFactory;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.log.ILogSvr;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectList;
import com.bokesoft.yigo.meta.dataobject.MetaDataObjectProfile;
import com.bokesoft.yigo.meta.deploy.MetaDeploy;
import com.bokesoft.yigo.meta.enhance.MetaEnhance;
import com.bokesoft.yigo.meta.enhance.MetaExtStartListener;
import com.bokesoft.yigo.meta.enhance.MetaStartListener;
import com.bokesoft.yigo.meta.factory.FileResourceResolver;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.meta.setting.MetaBPMSetting;
import com.bokesoft.yigo.meta.setting.MetaIOProvider;
import com.bokesoft.yigo.meta.setting.MetaIOService;
import com.bokesoft.yigo.meta.setting.MetaSession;
import com.bokesoft.yigo.meta.setting.MetaSetting;
import com.bokesoft.yigo.meta.setting.MetaSimpleSetting;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.DBType;
import com.bokesoft.yigo.mid.document.io.DocumentIOFactory;
import com.bokesoft.yigo.mid.document.io.IOFactory;
import com.bokesoft.yigo.mid.dsn.IDSNFactory;
import com.bokesoft.yigo.mid.nosql.ConnectionFactory;
import com.bokesoft.yigo.mid.nosql.IConnectionFactory;
import com.bokesoft.yigo.mid.oid.IOIDAllocatorFactory;
import com.bokesoft.yigo.mid.scheduler.QuartzManager;
import com.bokesoft.yigo.mid.schemamgr.ISchemaCheckFactory;
import com.bokesoft.yigo.mid.schemamgr.ISchemaCreateFactory;
import com.bokesoft.yigo.mid.schemamgr.SchemaCheckFactory;
import com.bokesoft.yigo.mid.schemamgr.SchemaCreateFactory;
import com.bokesoft.yigo.mid.service.IServiceProcessFactory;
import com.bokesoft.yigo.mid.service.IServiceRightCheckerFactory;
import com.bokesoft.yigo.mid.service.ServiceRightCheckerFactory;
import com.bokesoft.yigo.mid.session.ISessionInfoMap;
import com.bokesoft.yigo.mid.session.ISessionInfoProvider;
import com.bokesoft.yigo.mid.session.SessionCacheFactory;
import com.bokesoft.yigo.mid.session.SessionInfoProviderHolder;
import com.bokesoft.yigo.mid.start.IStartListener;
import com.bokesoft.yigo.parser.IFunctionProvider;
import com.bokesoft.yigo.session.RedisSessionCacheFactory;
import com.bokesoft.yigo.session.SimpleSessionCacheFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.quartz.Job;

public class MidSystemInit {
    private ArrayList<IStartListener> listeners = new ArrayList();
    private boolean startWithDSN = true;
    public static boolean initSucessed = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void impl_init() throws Throwable {
        MetaExtStartListener extStartListener;
        this.initSetting();
        MidFunctionImplMap.getMidInstance().regFunctionProvider((IFunctionProvider)new MidFunctionProvider());
        MidFunctionImplMap.getMidInstance().regFunctionProvider((IFunctionProvider)new DesignMidFunctionProvider());
        MidFunctionImplMap.getMidInstance().regFunctionProvider((IFunctionProvider)new ExcelMidFunctionProvider());
        DocumentFunctionMap.getDataTableInstance().regFunctionProvider((IFunctionProvider)new DocumentFunctionProvider());
        DictItemCacheFactory.setInstance((IDictItemCacheFactory)new MidDictItemCacheFactory());
        RightsProviderFactory.setInstance((IRightsProviderFactory)new MidUserRightsFactory());
        FormRightsProxyFactory.setInstance((IFormRightsProxyFactory)new DefaultFormRightsProxyFactory());
        BPMSchemaProxyFactory.setInstance((IBPMSchemaProxyFactory)new DefaultBPMSchemaProxyFactory());
        DictTreeServiceProxyFactory.setInstance((IDictTreeServiceProxyFactory)new MidDictTreeServiceProxyFactory());
        DictCacheProxyFactory.setInstance((IDictCacheProxyFactory)new MidDictCacheProxyFactory());
        MidFunctionImplMap.getMidInstance().regFunctionProvider((IFunctionProvider)new BPMMidFunctionProvider());
        MidGlobalEnv midEnv = MidGlobalEnv.getInstance();
        ServerSetting setting = ServerSetting.getInstance();
        Object createfactory = null;
        createfactory = setting.getSchemaCreateFactory() != null && !setting.getSchemaCreateFactory().isEmpty() ? (ISchemaCreateFactory)ReflectHelper.newInstanceByClassLoader((ClassLoader)midEnv.getPluginsClassLoader(), (String)setting.getSchemaCreateFactory()) : new MidSchemaCreateFactory();
        SchemaCreateFactory.setInstance((ISchemaCreateFactory)createfactory);
        Object checkfactory = null;
        checkfactory = setting.getSchemaCheckFactory() != null && !setting.getSchemaCheckFactory().isEmpty() ? (ISchemaCheckFactory)ReflectHelper.newInstanceByClassLoader((ClassLoader)midEnv.getPluginsClassLoader(), (String)setting.getSchemaCheckFactory()) : new MidSchemaCheckFactory();
        SchemaCheckFactory.setInstance((ISchemaCheckFactory)checkfactory);
        OIDAllocatorFactory.setInstance((IOIDAllocatorFactory)new MidOIDAllocatorFactory());
        MetaEnhance enhance = midEnv.getMetaFactory().getEnhance("");
        if (enhance != null && (extStartListener = enhance.getStartListener()) != null) {
            for (int i = 0; i < extStartListener.size(); ++i) {
                MetaStartListener metaListener = (MetaStartListener)extStartListener.get(i);
                String implPath = metaListener.getImpl();
                IStartListener listener = (IStartListener)ReflectHelper.newInstanceByClassLoader((ClassLoader)midEnv.getPluginsClassLoader(), (String)implPath);
                this.listeners.add(listener);
            }
        }
        DefaultMidVEFactory veFactory = new DefaultMidVEFactory();
        try (DefaultContext context = new DefaultContext(veFactory.createVE());){
            IMetaFactory metaFactory = context.getVE().getMetaFactory();
            metaFactory.initParaTable();
            this.loadVestDataObject(metaFactory);
            this.loadVestForm(metaFactory);
            metaFactory.preLoadEntity();
            String cacheName = SvrInfo.getCacheName();
            this.initCacheFactory(cacheName, metaFactory);
            String sessionCacheName = SvrInfo.getSessionCacheName();
            this.initSessionCacheFactory(sessionCacheName, metaFactory);
            this.initConnectionFactory(cacheName, sessionCacheName);
            DictItemCacheFactory.setInstance((IDictItemCacheFactory)new MidDictItemCacheFactory());
            RightsProviderFactory.setInstance((IRightsProviderFactory)new MidUserRightsFactory());
            FormRightsProxyFactory.setInstance((IFormRightsProxyFactory)new DefaultFormRightsProxyFactory());
            BPMSchemaProxyFactory.setInstance((IBPMSchemaProxyFactory)new DefaultBPMSchemaProxyFactory());
            DictTreeServiceProxyFactory.setInstance((IDictTreeServiceProxyFactory)new MidDictTreeServiceProxyFactory());
            MidFunctionImplMap.getMidInstance().regFunctionProvider((IFunctionProvider)new BPMMidFunctionProvider());
            ServiceRightCheckerFactory.setInstance((IServiceRightCheckerFactory)new DefaultServiceRightCheckerFactory());
            this.initSessionCacheInfo(metaFactory);
            this.initAccountLockoutInfo(metaFactory);
            DBMaintainceListener dbMaintain = new DBMaintainceListener();
            dbMaintain.invoke(context);
            context.commit();
            PreLoadProcessInDB preLoadProcessInDB = new PreLoadProcessInDB();
            preLoadProcessInDB.load(context);
            this.doStartListener(context);
            context.commit();
            MetaFormList AutoFormList = new MetaFormList();
            for (MetaFormProfile metaFormProfile : metaFactory.getMetaFormList()) {
                metaFactory.getAutoMetaForm(metaFormProfile.getKey(), AutoFormList);
            }
            for (MetaFormProfile metaFormProfile : AutoFormList) {
                metaFactory.getMetaFormList().add((KeyPairMetaObject)metaFormProfile);
            }
            this.midProcessInit();
            this.midQuartzStart(context);
            this.doBackgroundTask(context);
            context.commit();
        }
    }

    private void loadVestForm(IMetaFactory metaFactory) throws Throwable {
        MetaForm metaForm;
        ArrayList templateList = new ArrayList();
        ArrayList notTemplateList = new ArrayList();
        MetaFormList formList = metaFactory.getMetaFormList();
        formList.forEach(metaFormProfile -> {
            boolean isVestDiff;
            String extendFormKey = metaFormProfile.getExtend();
            Boolean mergeToSource = metaFormProfile.getMergeToSource();
            boolean bl = isVestDiff = mergeToSource != false && extendFormKey != null && !extendFormKey.isEmpty();
            if (isVestDiff) {
                String key = metaFormProfile.getKey();
                if (((MetaFormProfile)formList.get(extendFormKey)).getFormType() == 8) {
                    templateList.add(key);
                } else {
                    notTemplateList.add(key);
                }
            }
        });
        for (String key : templateList) {
            metaForm = null;
            metaForm = metaFactory.getMetaForm(key);
            metaFactory.replaceMetaForm4VestDiff(metaForm.getExtend(), metaForm);
        }
        for (String key : notTemplateList) {
            metaForm = null;
            metaForm = metaFactory.getMetaForm(key);
            metaFactory.replaceMetaForm4VestDiff(metaForm.getExtend(), metaForm);
        }
    }

    private void loadVestDataObject(IMetaFactory metaFactory) throws Throwable {
        ArrayList templateList = new ArrayList();
        ArrayList notTemplateList = new ArrayList();
        MetaDataObjectList dataObjectList = metaFactory.getDataObjectList();
        dataObjectList.forEach(dataObjectProfile -> {
            boolean isVestDiff;
            String extendDataObjectKey = dataObjectProfile.getExtend();
            boolean bl = isVestDiff = extendDataObjectKey != null && !extendDataObjectKey.isEmpty();
            if (isVestDiff) {
                String key = dataObjectProfile.getKey();
                if (((MetaDataObjectProfile)dataObjectList.get(extendDataObjectKey)).getPrimaryType() == 2) {
                    templateList.add(key);
                } else {
                    notTemplateList.add(key);
                }
            }
        });
        for (String key : templateList) {
            metaFactory.getDataObject(key);
        }
        for (String key : notTemplateList) {
            metaFactory.getDataObject(key);
        }
    }

    private void initGlobalLock(String lockImplClass) throws Throwable {
        try {
            ILock lock = (ILock)Class.forName(lockImplClass).newInstance();
            LockFactory.setInstance((ILock)lock);
        }
        catch (Throwable e) {
            LogSvr.getInstance().info("ILock\u9501\u53cd\u5c04\u5931\u8d25");
            throw e;
        }
    }

    private void initConnectionFactory(String cacheName, String sessionCacheName) {
        if (cacheName.equals("redis") || sessionCacheName.equals("redis")) {
            ConnectionFactory.setInstance((IConnectionFactory)new RedisConnectionFactory());
        }
    }

    public void init() throws Throwable {
        try {
            this.impl_init();
        }
        catch (Throwable e) {
            e.printStackTrace();
            initSucessed = false;
            MetaFactory.setGlobalInstance(null);
            LogSvr.getInstance().info("\u5e94\u7528\u521d\u59cb\u5316\u5931\u8d25");
            throw e;
        }
    }

    private void doStartListener(DefaultContext context) throws Throwable {
        if (!this.startWithDSN) {
            return;
        }
        Iterator<IStartListener> it = this.listeners.iterator();
        IStartListener listener = null;
        while (it.hasNext()) {
            listener = it.next();
            listener.invoke(context);
        }
    }

    protected void initSetting() throws Throwable {
        LogSvr.setInstance((com.bokesoft.yes.common.log.ILogSvr)new NullLogSvr());
        CoreSetting coreSetting = CoreSetting.getInstance();
        ServerSetting serverSetting = ServerSetting.getInstance();
        try {
            MetaIOService IOService;
            MetaSetting setting;
            String guestKick;
            String cache;
            String cache2;
            String cache3;
            FileInputStream vis;
            FileInputStream coreIs = PropertyUtil.readProperties((String)"core.properties");
            PropertyResourceBundle coreBundle = new PropertyResourceBundle(coreIs);
            if (coreBundle.containsKey("SolutionPath")) {
                String s;
                String solutionPath = coreBundle.getString("SolutionPath").trim();
                coreSetting.setSolutionPath(solutionPath.replaceAll("//", "/"));
                String pluginsPath = solutionPath + File.separatorChar + "Enhance";
                if (coreBundle.containsKey("PluginsPath") && !StringUtil.isBlankOrNull((String)(s = coreBundle.getString("PluginsPath").trim()))) {
                    pluginsPath = s;
                }
                coreSetting.setPluginsSourcePath(pluginsPath.replace("//", "/"));
            }
            String logSvrImpl = null;
            if (coreBundle.containsKey("LOGSVR")) {
                logSvrImpl = coreBundle.getString("LOGSVR");
            }
            if (logSvrImpl != null && !logSvrImpl.isEmpty()) {
                ILogSvr impl = null;
                if (logSvrImpl.indexOf(".") != -1) {
                    impl = (ILogSvr)ReflectUtil.newInstance((String)logSvrImpl);
                } else if ("log4j".equalsIgnoreCase(logSvrImpl)) {
                    impl = new LogSvrImpl();
                }
                LogSvr.setInstance((com.bokesoft.yes.common.log.ILogSvr)impl);
            }
            if (coreBundle.containsKey("DEFAULTAPP")) {
                String appKey = coreBundle.getString("DEFAULTAPP");
                coreSetting.setAppKey(appKey);
            }
            if (coreBundle.containsKey("APPID")) {
                String appID = coreBundle.getString("APPID");
                coreSetting.setAppID(appID);
            }
            if (coreBundle.containsKey("RightChkLevel")) {
                String rightChkLevel = coreBundle.getString("RightChkLevel");
                coreSetting.setRightChkLevel(rightChkLevel);
            }
            if (coreBundle.containsKey("SOLUTIONS")) {
                this.dealwithSolutions(coreBundle, coreSetting);
            }
            if (coreBundle.containsKey("DictMatchUpper")) {
                boolean b = TypeConvertor.toBoolean((Object)coreBundle.getString("DictMatchUpper"));
                coreSetting.setDictMatchUpper(b);
            }
            coreIs.close();
            LogSvr.getInstance().info(StringTable.getString(null, "", "SysInit"));
            FileInputStream serverIs = PropertyUtil.readProperties((String)"server.properties");
            if (serverIs != null) {
                PropertyResourceBundle serverBundle = new PropertyResourceBundle(serverIs);
                String s = serverBundle.getString("EncryptDSN");
                if (s != null && s.equalsIgnoreCase("true")) {
                    serverSetting.setEncryptDSN(true);
                    String dsnPKL = serverBundle.getString("DSNPKL");
                    if (dsnPKL == null || dsnPKL.isEmpty()) {
                        dsnPKL = SvrInfo.getWorkDir() + "dsn.pkl";
                    }
                    serverSetting.setDSNPKL(dsnPKL);
                }
                if ((s = serverBundle.getString("FileSessionPKL")) != null && s.equalsIgnoreCase("true")) {
                    serverSetting.setFileSessionPKL(true);
                    String sessionPKL = serverBundle.getString("SessionPKL");
                    if (sessionPKL == null || sessionPKL.isEmpty()) {
                        sessionPKL = SvrInfo.getWorkDir() + "session.pkl";
                    }
                    serverSetting.setSessionPKL(sessionPKL);
                }
                if (serverBundle.containsKey("ValidateLevel") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("ValidateLevel")))) {
                    String[] arr;
                    for (String tmp : arr = StringUtil.split((String)s, (String)",")) {
                        serverSetting.addValidateLevel(TypeConvertor.toInteger((Object)tmp).intValue());
                    }
                }
                if (serverBundle.containsKey("SecurityLevel") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("SecurityLevel")))) {
                    serverSetting.setSecurityLevel(TypeConvertor.toInteger((Object)s).intValue());
                }
                if (serverBundle.containsKey("PasswordDuration") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("PasswordDuration")))) {
                    serverSetting.setPasswordDuration(TypeConvertor.toInteger((Object)s).intValue());
                }
                if (serverBundle.containsKey("PasswordHistorySize") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("PasswordHistorySize")))) {
                    serverSetting.setPasswordHistorySize(TypeConvertor.toInteger((Object)s).intValue());
                }
                if (serverBundle.containsKey("ValidateCreator") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("ValidateCreator")))) {
                    serverSetting.setValidateCreator(s);
                }
                if (serverBundle.containsKey("CertificatePath") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("CertificatePath")))) {
                    serverSetting.setCertificatePath(s);
                }
                if (serverBundle.containsKey("CertificateWarehouseCreator") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("CertificateWarehouseCreator")))) {
                    serverSetting.setCertificateWarehouseCreator(s);
                }
                if (serverBundle.containsKey("SessionKeepTime") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("SessionKeepTime")))) {
                    serverSetting.setSessionKeepTime(TypeConvertor.toLong((Object)s));
                }
                if (serverBundle.containsKey("TicketIDClearPeriod") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("TicketIDClearPeriod")))) {
                    serverSetting.setTicketIDClearPeriod(TypeConvertor.toLong((Object)s));
                }
                if (serverBundle.containsKey("PasswordRule") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("PasswordRule")))) {
                    serverSetting.setPasswordRule(TypeConvertor.toString((Object)s));
                }
                if (serverBundle.containsKey("SupportHotDeploy") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("SupportHotDeploy")))) {
                    serverSetting.setSupportHotDeploy(TypeConvertor.toBoolean((Object)s).booleanValue());
                }
                if (serverBundle.containsKey("AllowHotDeployTest") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("AllowHotDeployTest")))) {
                    serverSetting.setAllowHotDeployTest(TypeConvertor.toBoolean((Object)s).booleanValue());
                }
                if (serverBundle.containsKey("UseVariant") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("UseVariant")))) {
                    serverSetting.setUseVariant(TypeConvertor.toBoolean((Object)s).booleanValue());
                }
                if (serverBundle.containsKey("SchemaCreateFactory") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("SchemaCreateFactory")))) {
                    serverSetting.setSchemaCreateFactory(s);
                }
                if (serverBundle.containsKey("SchemaCheckFactory") && !StringUtil.isBlankOrNull((String)(s = serverBundle.getString("SchemaCheckFactory")))) {
                    serverSetting.setSchemaCheckFactory(s);
                }
                if ((s = serverBundle.getString("Master")) != null) {
                    if (s.equalsIgnoreCase("true")) {
                        serverSetting.setMaster(true);
                    } else {
                        serverSetting.setMaster(false);
                    }
                }
                if (serverBundle.containsKey("NodePort")) {
                    s = serverBundle.getString("NodePort");
                    serverSetting.setNodePort(s);
                }
                if (serverBundle.containsKey("StatusReceiverPort")) {
                    s = serverBundle.getString("StatusReceiverPort");
                    serverSetting.setStatusReceiverPort(s);
                }
                if (serverBundle.containsKey("NodeInstanceID")) {
                    s = serverBundle.getString("NodeInstanceID");
                    serverSetting.setNodeInstanceID(s);
                }
                if (serverBundle.containsKey("DSNFactory")) {
                    s = serverBundle.getString("DSNFactory");
                    serverSetting.setDSNFactory(s);
                }
                serverIs.close();
            }
            if ((vis = PropertyUtil.readProperties((String)"variant.properties")) != null) {
                PropertyResourceBundle vbundle = new PropertyResourceBundle(vis);
                String s = null;
                if (vbundle.containsKey("SourceType") && !StringUtil.isBlankOrNull((String)(s = vbundle.getString("SourceType")))) {
                    int type = VariantSetting.getInstance().parse(s);
                    VariantSetting.getInstance().setSourceType(type);
                }
                if (vbundle.containsKey("KeyGeneratorClass") && !StringUtil.isBlankOrNull((String)(s = vbundle.getString("KeyGeneratorClass")))) {
                    VariantSetting.getInstance().setKeyGeneratorClass(s);
                }
                if (vbundle.containsKey("VariantIOFactoryClass") && !StringUtil.isBlankOrNull((String)(s = vbundle.getString("VariantIOFactoryClass")))) {
                    VariantSetting.getInstance().setVariantIOFactoryClass(s);
                }
                vis.close();
            }
            String dsn = null;
            if (coreBundle.containsKey("DSN")) {
                dsn = coreBundle.getString("DSN");
            }
            String authorityImpl = null;
            if (coreBundle.containsKey("AUTHORITYIMPL")) {
                authorityImpl = coreBundle.getString("AUTHORITYIMPL");
                this.initAuthorityImpl(authorityImpl);
            }
            String structuredAuthorityImpl = null;
            if (coreBundle.containsKey("STRUCTUREDAUTHORITYIMPL") && StringUtils.isNotBlank((CharSequence)(structuredAuthorityImpl = coreBundle.getString("STRUCTUREDAUTHORITYIMPL")))) {
                this.initStructuredAuthorityImpl(structuredAuthorityImpl);
            }
            String lockImpl = null;
            if (coreBundle.containsKey("LOCKIMPL")) {
                lockImpl = coreBundle.getString("LOCKIMPL");
            }
            if (StringUtils.isNotBlank(lockImpl)) {
                this.initGlobalLock(lockImpl);
            }
            String defaultDSN = null;
            if (coreBundle.containsKey("DEFAULT")) {
                defaultDSN = coreBundle.getString("DEFAULT");
            }
            String defaultArchiveDSN = coreBundle.containsKey("DefaultArchiveDSN") ? coreBundle.getString("DefaultArchiveDSN") : null;
            if (dsn != null && !dsn.isEmpty()) {
                DSNItemCollection dsnCollection = coreSetting.getDSNCollection();
                this.initDSNS(dsnCollection, dsn, defaultDSN, defaultArchiveDSN);
            } else {
                this.startWithDSN = false;
            }
            if (coreBundle.containsKey("DEBUG")) {
                String debug = coreBundle.getString("DEBUG");
                if (debug != null && debug.equalsIgnoreCase("true")) {
                    SvrInfo.setNeedDebug((boolean)true);
                } else {
                    SvrInfo.setNeedDebug((boolean)false);
                }
            }
            if (coreBundle.containsKey("LogServicePackage")) {
                String s = coreBundle.getString("LogServicePackage");
                SvrInfo.setLogServicePackage((boolean)Boolean.parseBoolean(s));
            }
            String clazz = serverSetting.getDSNFactory();
            DefaultDSNFactory dsnFactory = null;
            dsnFactory = clazz != null && !clazz.isEmpty() ? (IDSNFactory)ReflectUtil.newInstance((String)clazz) : new DefaultDSNFactory();
            dsnFactory.init();
            DSNFactory.setInstance((IDSNFactory)dsnFactory);
            MidEnvManager envManager = new MidEnvManager();
            envManager.init();
            MidGlobalEnv.setInstance((MidGlobalEnv)envManager.getEnv());
            IMetaFactory metaFactory = envManager.getEnv().getMetaFactory();
            MidGlobalEnvState.setRunningVersion((String)envManager.getEnv().getVersion());
            String solutionKey = metaFactory.getSolution().getKey();
            File fileDeploy = new File(SvrInfo.getWorkDir() + "deploy.xml");
            if (fileDeploy.exists()) {
                MetaDeployLoad deployLoad = new MetaDeployLoad(1);
                deployLoad.load((IMetaResolver)new FileResourceResolver(fileDeploy.getAbsolutePath()), "");
                serverSetting.setDeploy((MetaDeploy)deployLoad.getRootMetaObject());
            }
            LogSvr.getInstance().info(SimpleStringFormat.format((String)StringTable.getString(null, "", "ReadSolution"), (Object[])new Object[]{solutionKey}));
            String cacheName = "simple";
            if (coreBundle.containsKey("Cache") && (cache3 = coreBundle.getString("Cache")) != null && !cache3.isEmpty()) {
                cacheName = cache3;
            }
            if (coreBundle.containsKey("CACHE") && (cache3 = coreBundle.getString("CACHE")) != null && !cache3.isEmpty()) {
                cacheName = cache3;
            }
            SvrInfo.setCacheName((String)cacheName.toLowerCase());
            String sessionCache = SvrInfo.getCacheName();
            if (coreBundle.containsKey("SessionCache") && (cache2 = coreBundle.getString("SessionCache")) != null && !cache2.isEmpty()) {
                sessionCache = cache2;
            }
            if (coreBundle.containsKey("SESSIONCACHE") && (cache2 = coreBundle.getString("SESSIONCACHE")) != null && !cache2.isEmpty()) {
                sessionCache = cache2;
            }
            SvrInfo.setSessionCacheName((String)sessionCache.toLowerCase());
            String extendCache = SvrInfo.getCacheName();
            if (coreBundle.containsKey("ExtendCache") && (cache = coreBundle.getString("ExtendCache")) != null && !cache.isEmpty()) {
                extendCache = cache;
            }
            if (coreBundle.containsKey("EXTENDCACHE") && (cache = coreBundle.getString("EXTENDCACHE")) != null && !cache.isEmpty()) {
                extendCache = cache;
            }
            SvrInfo.setExtendCacheName((String)extendCache.toLowerCase());
            if (coreBundle.containsKey("KICK")) {
                String kick = coreBundle.getString("KICK");
                if (kick != null && kick.equalsIgnoreCase("false")) {
                    SvrInfo.setKick((boolean)false);
                } else {
                    SvrInfo.setKick((boolean)true);
                }
            }
            if (coreBundle.containsKey("GuestKick")) {
                guestKick = coreBundle.getString("GuestKick");
                if (guestKick != null && guestKick.equalsIgnoreCase("false")) {
                    SvrInfo.setGuestKick((boolean)false);
                } else {
                    SvrInfo.setGuestKick((boolean)true);
                }
            }
            if (coreBundle.containsKey("GUESTKICK")) {
                guestKick = coreBundle.getString("GUESTKICK");
                if (guestKick != null && guestKick.equalsIgnoreCase("false")) {
                    SvrInfo.setGuestKick((boolean)false);
                } else {
                    SvrInfo.setGuestKick((boolean)true);
                }
            }
            if (coreBundle.containsKey("NoRightInfoType")) {
                String noRightInfoType = coreBundle.getString("NoRightInfoType");
                SvrInfo.setNoRightInfoType((String)noRightInfoType);
            }
            if ((setting = metaFactory.getSetting()) != null && (IOService = setting.getIOService()) != null) {
                for (MetaIOProvider provider : IOService) {
                    Class<?> providerClass = Class.forName(provider.getDriver());
                    DocumentIOFactory documentIOFactory = (DocumentIOFactory)providerClass.newInstance();
                    IOFactory.setDocumentIOFactory((String)provider.getKey(), (DocumentIOFactory)documentIOFactory);
                }
            }
        }
        catch (MissingResourceException e) {
            LogSvr.getInstance().error("missing core", (Throwable)e);
            throw e;
        }
        catch (Throwable e) {
            LogSvr.getInstance().error("start yigo error", e);
            throw e;
        }
    }

    private void initAuthorityImpl(String authorityImpl) throws Throwable {
        if (StringUtil.isBlankOrNull((String)authorityImpl)) {
            AuthorityProviderFactory.setAuthorityProvider((IAuthorityProvider)new AuthorityProvider());
        } else {
            try {
                IAuthorityProvider authorityProvider = (IAuthorityProvider)Class.forName(authorityImpl).newInstance();
                AuthorityProviderFactory.setAuthorityProvider((IAuthorityProvider)authorityProvider);
            }
            catch (Throwable e) {
                LogSvr.getInstance().info("\u6ce8\u5165\u6743\u9650\u68c0\u67e5\u63a5\u53e3\u5931\u8d25");
                throw e;
            }
        }
    }

    private void initStructuredAuthorityImpl(String structuredAuthorityImpl) throws Throwable {
        try {
            IStructuredAuthorityProvider structuredAuthorityProvider = (IStructuredAuthorityProvider)Class.forName(structuredAuthorityImpl).newInstance();
            AuthorityProviderFactory.setStructuredAuthorityProvider((IStructuredAuthorityProvider)structuredAuthorityProvider);
        }
        catch (Throwable e) {
            LogSvr.getInstance().info("\u6ce8\u5165\u7ed3\u6784\u5316\u6743\u9650\u68c0\u67e5\u63a5\u53e3\u5931\u8d25");
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dealwithSolutions(PropertyResourceBundle coreBundle, CoreSetting coreSetting) throws Throwable {
        String s = coreBundle.getString("SOLUTIONS").trim();
        if (StringUtil.isBlankOrNull((String)s)) {
            return;
        }
        String[] solutions = s.split(",");
        ArrayList<ResolverProfile> profiles = new ArrayList<ResolverProfile>();
        ResolverProfile profile = null;
        boolean flag = false;
        for (String solution : solutions) {
            profile = new ResolverProfile();
            PropertyResourceBundle bundle = null;
            try (FileInputStream is = null;){
                is = PropertyUtil.readProperties((String)(solution + ".properties"));
                if (is == null) continue;
                bundle = new PropertyResourceBundle(is);
                Enumeration<String> keys = bundle.getKeys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    if (key.equals("IMPL")) {
                        String impl = bundle.getString("IMPL");
                        if (StringUtil.isBlankOrNull((String)impl)) continue;
                        profile.setImpl(impl);
                        continue;
                    }
                    if (key.equals("PRIMARY")) {
                        String primary = bundle.getString("PRIMARY");
                        if (StringUtil.isBlankOrNull((String)primary)) continue;
                        flag = true;
                        profile.setPrimary(TypeConvertor.toBoolean((Object)primary).booleanValue());
                        continue;
                    }
                    if (key.equals("DIFF")) {
                        String diff = bundle.getString("DIFF");
                        if (StringUtil.isBlankOrNull((String)diff)) continue;
                        profile.setDiff(TypeConvertor.toBoolean((Object)diff).booleanValue());
                        continue;
                    }
                    if (!key.startsWith("PARA.")) continue;
                    String paraKey = key.substring(5);
                    String paraValue = bundle.getString(key);
                    if (paraKey.isEmpty() || StringUtil.isBlankOrNull((String)paraValue)) continue;
                    if (paraKey.equals("SOLUTIONPATH")) {
                        paraValue = paraValue.trim().replaceAll("//", "/");
                    }
                    profile.putPara(paraKey, (Object)paraValue);
                }
                profiles.add(profile);
            }
        }
        if (profiles.size() > 0) {
            coreSetting.setSolutions(profiles);
            if (!flag) {
                ((ResolverProfile)profiles.get(0)).setPrimary(true);
            }
        }
    }

    protected void initSessionCacheInfo(IMetaFactory metaFactory) {
        SimpleSessionInfoProvider simpleProvider = new SimpleSessionInfoProvider();
        MobileSessionInfoProvider mobileProvider = new MobileSessionInfoProvider();
        TempSessionInfoProvider tmpProvider = new TempSessionInfoProvider();
        OvertimeSessionInfoProvider overtimeProvider = new OvertimeSessionInfoProvider();
        MetaSetting setting = metaFactory.getSetting();
        MetaSimpleSetting mss = null;
        if (setting != null) {
            String clazz;
            try {
                mss = setting.getSimpleSetting("SimpleSessionInfoProvider");
                if (mss != null && (clazz = mss.get("Impl")) != null && !clazz.isEmpty()) {
                    simpleProvider = (ISessionInfoProvider)Class.forName(clazz).newInstance();
                }
            }
            catch (Throwable e) {
                LogSvr.getInstance().error("SimpleSessionInfoProvider is error.", e);
            }
            try {
                mss = setting.getSimpleSetting("MobileSessionInfoProvider");
                if (mss != null && (clazz = mss.get("Impl")) != null && !clazz.isEmpty()) {
                    mobileProvider = (ISessionInfoProvider)Class.forName(clazz).newInstance();
                }
            }
            catch (Throwable e) {
                LogSvr.getInstance().error("MobileSessionInfoProvider is error.", e);
            }
            try {
                mss = setting.getSimpleSetting("TempSessionInfoProvider");
                if (mss != null && (clazz = mss.get("Impl")) != null && !clazz.isEmpty()) {
                    tmpProvider = (ISessionInfoProvider)Class.forName(clazz).newInstance();
                }
            }
            catch (Throwable e) {
                LogSvr.getInstance().error("TempSessionInfoProvider is error.", e);
            }
            try {
                mss = setting.getSimpleSetting("OvertimeSessionInfoProvider");
                if (mss != null && (clazz = mss.get("Impl")) != null && !clazz.isEmpty()) {
                    overtimeProvider = (ISessionInfoProvider)Class.forName(clazz).newInstance();
                }
            }
            catch (Throwable e) {
                LogSvr.getInstance().error("OvertimeSessionInfoProvider is error.", e);
            }
        }
        SessionInfoProviderHolder.setSimpleInstance((ISessionInfoProvider)simpleProvider);
        SessionInfoProviderHolder.setMobileInstance((ISessionInfoProvider)mobileProvider);
        SessionInfoProviderHolder.setTempInstance((ISessionInfoProvider)tmpProvider);
        SessionInfoProviderHolder.setOvertimeInstance((ISessionInfoProvider)overtimeProvider);
        simpleProvider = SessionInfoProviderHolder.getSimpleProvider();
        ISessionInfoMap simpleMap = simpleProvider.getSessionInfoMap();
        mobileProvider = SessionInfoProviderHolder.getMobileProvider();
        ISessionInfoMap mobileMap = mobileProvider.getSessionInfoMap();
        tmpProvider = SessionInfoProviderHolder.getTempProvider();
        ISessionInfoMap tmpMap = tmpProvider.getSessionInfoMap();
        if (setting != null) {
            MetaSession metaSession = setting.getSession();
            simpleMap.setTimeout(metaSession == null ? 3600 : metaSession.getTimeout());
            mobileMap.setTimeout(metaSession == null ? 3600 : metaSession.getDelMobileTimeout());
            tmpMap.setTimeout(metaSession == null ? 3600 : metaSession.getTimeout());
        } else {
            simpleMap.setTimeout(3600);
            mobileMap.setTimeout(3600);
            tmpMap.setTimeout(3600);
        }
    }

    protected void initAccountLockoutInfo(IMetaFactory metaFactory) {
        IAccountLockoutInfoMap lockInfo = AccountLockoutInfoProvider.getInstance().getAccountLockoutInfoMap();
        MetaSetting setting = metaFactory.getSetting();
        if (setting != null) {
            MetaSession metaSession = setting.getSession();
            lockInfo.setAccountLockoutDuration(metaSession == null ? 0 : metaSession.getAccountLockoutDuration());
            lockInfo.setAccountLockoutThreshold(metaSession == null ? 0 : metaSession.getAccountLockoutThreshold());
            lockInfo.setUserLockInfoIsPersist(Boolean.valueOf(metaSession == null ? false : metaSession.getUserLockInfoIsPersist()));
        }
    }

    protected void initCacheFactory(String cacheName, IMetaFactory metaFactory) throws Throwable {
        switch (cacheName) {
            case "redis": {
                CacheFactory.setInstance((ICacheFactory)new RedisCacheFactory());
                LogSvr.getInstance().info("use app cache " + cacheName);
                break;
            }
            case "ehcache": 
            case "simple": {
                if ("ehcache".equals(cacheName)) {
                    LogSvr.getInstance().info("ehcache deprecated, use simple instead");
                }
                CacheFactory.setInstance((ICacheFactory)new SimpleCacheFactory());
                LogSvr.getInstance().info("use app cache simple");
                break;
            }
            default: {
                throw new MidAppException(4, SimpleStringFormat.format((String)StringTable.getString(null, "", "UnknownCacheName"), (Object[])new Object[]{cacheName}));
            }
        }
    }

    protected void initSessionCacheFactory(String cacheName, IMetaFactory metaFactory) {
        switch (cacheName) {
            case "redis": {
                SessionCacheFactory.setInstance((com.bokesoft.yigo.mid.session.ICacheFactory)new RedisSessionCacheFactory(metaFactory));
                LogSvr.getInstance().info("use session cache " + cacheName.toLowerCase());
                break;
            }
            case "simple": 
            case "ehcache": {
                if ("ehcache".equals(cacheName)) {
                    LogSvr.getInstance().info("ehcache deprecated, use simple instead");
                }
                SessionCacheFactory.setInstance((com.bokesoft.yigo.mid.session.ICacheFactory)new SimpleSessionCacheFactory());
                LogSvr.getInstance().info("use session cache simple");
                break;
            }
            default: {
                throw new MidAppException(4, SimpleStringFormat.format((String)StringTable.getString(null, "", "UnknownCacheName"), (Object[])new Object[]{cacheName}));
            }
        }
    }

    protected void initDSNS(DSNItemCollection dsnCollection, String dsns, String defaultDSN, String defaultArchiveDSN) throws Throwable {
        ServerSetting serverSetting = ServerSetting.getInstance();
        boolean encryptDSN = serverSetting.isEncryptDSN();
        String[] vDsn = dsns.split(",");
        int length = vDsn.length;
        String firstDSN = null;
        String lastDSN = null;
        for (int i = 0; i < length; ++i) {
            String extConfig;
            String connectionFactory;
            String dbFactory;
            DBDSNItem dbItem;
            String dsn = vDsn[i];
            if (i == 0) {
                firstDSN = dsn;
            }
            if (i == length - 1) {
                lastDSN = dsn;
            }
            FileInputStream fis = PropertyUtil.readProperties((String)(dsn + ".properties"));
            PropertyResourceBundle dsnBundle = new PropertyResourceBundle(fis);
            fis.close();
            DBDSNItem item = null;
            item = dbItem = new DBDSNItem();
            dbItem.setName(dsnBundle.getString("Name"));
            String connectionTypeString = dsnBundle.getString("ConnectionType");
            if ("dbcp".equalsIgnoreCase(connectionTypeString)) {
                dbItem.setConnectionType(1);
            } else if ("jndi".equalsIgnoreCase(connectionTypeString)) {
                dbItem.setConnectionType(2);
            } else {
                dbItem.setConnectionType(0);
            }
            dbItem.setDriver(dsnBundle.getString("Driver"));
            dbItem.setURL(dsnBundle.getString("URL"));
            dbItem.setUser(dsnBundle.getString("User"));
            String password = dsnBundle.getString("Password");
            if (encryptDSN) {
                byte[] b1 = Base64.decode((byte[])password.getBytes());
                b1 = Hex.decodeHex((char[])new String(b1).toCharArray());
                String privateKey = "";
                File pklFile = new File(serverSetting.getDSNPKL());
                FileReader reader = new FileReader(pklFile);
                BufferedReader br = new BufferedReader(reader);
                br.readLine();
                privateKey = br.readLine();
                br.close();
                reader.close();
                RSA rsa = new RSA();
                b1 = rsa.decryptByPrivate(b1, privateKey);
                password = new String(b1);
            }
            dbItem.setPassword(password);
            String dbTypeString = dsnBundle.getString("DBType");
            if (dbTypeString.isEmpty()) {
                dbTypeString = this.resolveDBType(dbItem.getDriver());
            }
            dbItem.setDBType(DBType.parse((String)dbTypeString));
            if (dsnBundle.containsKey("DBFactory") && (dbFactory = dsnBundle.getString("DBFactory")) != null && !dbFactory.isEmpty()) {
                dbItem.setDBFactory(dbFactory);
            }
            if (dsnBundle.containsKey("ConnectionFactory") && (connectionFactory = dsnBundle.getString("ConnectionFactory")) != null && !connectionFactory.isEmpty()) {
                dbItem.setConnectionFactoryClazz(connectionFactory);
            }
            if (dsnBundle.containsKey("ExtConfig") && (extConfig = dsnBundle.getString("ExtConfig")) != null && !extConfig.isEmpty()) {
                FileInputStream extfis = PropertyUtil.readProperties((String)(extConfig + ".properties"));
                PropertyResourceBundle extConfigBundle = new PropertyResourceBundle(extfis);
                extfis.close();
                Enumeration<String> extPropKeys = extConfigBundle.getKeys();
                while (extPropKeys.hasMoreElements()) {
                    String extPropKey = extPropKeys.nextElement();
                    String extPropValue = extConfigBundle.getString(extPropKey);
                    dbItem.addExtProp(extPropKey, extPropValue);
                }
            }
            dsnCollection.addDSNItem((DSNItem)item);
        }
        if (defaultDSN != null) {
            defaultDSN = defaultDSN.trim();
        }
        if (defaultDSN == null || defaultDSN.isEmpty()) {
            defaultDSN = firstDSN;
        }
        if (defaultDSN != null && !defaultDSN.isEmpty()) {
            DSNItem defaultDSNItem = dsnCollection.getDSNItem(defaultDSN);
            if (defaultDSNItem == null) {
                throw new MidAppException(1, SimpleStringFormat.format((String)StringTable.getString(null, "", "OneDSNUnDefined"), (Object[])new Object[0]));
            }
            dsnCollection.setDefaultDSN(defaultDSNItem);
        }
        if (defaultArchiveDSN != null) {
            defaultArchiveDSN = defaultArchiveDSN.trim();
        }
        if (defaultArchiveDSN == null || defaultArchiveDSN.isEmpty()) {
            defaultArchiveDSN = lastDSN;
        }
        if (defaultArchiveDSN != null && !defaultDSN.isEmpty()) {
            DSNItem defaultArchiveDSNItem = dsnCollection.getDSNItem(defaultArchiveDSN);
            if (defaultArchiveDSNItem == null) {
                throw new MidAppException(1, SimpleStringFormat.format((String)StringTable.getString(null, "", "OneDSNUnDefined"), (Object[])new Object[0]));
            }
            dsnCollection.setDefaultArchiveDSN(defaultArchiveDSNItem);
        }
    }

    private String resolveDBType(String driver) {
        return "";
    }

    private void midProcessInit() {
        MidProcessFlowHandler.addProcessFactory((String)"DBNamedQuery", (String)"Pre", (String)"com.bokesoft.pub.mid.filter.process.DBNamedQueryProcess");
        MidProcessFlowHandler.addProcessFactory((String)"DBNamedUpdate", (String)"Pre", (String)"com.bokesoft.pub.mid.filter.process.DBNamedUpdateProcess");
        MidProcessFlowHandler.addProcessFactory((String)"InvokeExtServiceCmd", (String)"Pre", (String)"com.bokesoft.pub.mid.filter.process.InvokeExtServiceProcess");
        MidProcessFlowHandler.addProcessFactory((String)"InvokeExtService2Cmd", (String)"Pre", (String)"com.bokesoft.pub.mid.filter.process.InvokeExtService2Process");
        MidProcessFlowHandler.addProcessFactory((String)"DeleteData", (String)"Pre", (String)"com.bokesoft.pub.mid.filter.process.DeleteDataRightsProcess");
        MidProcessFlowHandler.addProcessFactory((String)"LoadData", (String)"Post", (String)"com.bokesoft.pub.mid.filter.process.LoadDataRightsProcess");
        MidProcessFlowHandler.addProcessFactory((String)"SaveData", (String)"Pre", (String)"com.bokesoft.pub.mid.filter.process.SaveDataRightsProcess");
        MidProcessFlowHandler.addProcessFactory((String)"LoadData", (String)"Post", (IServiceProcessFactory)new LoadBPMFactory());
        MidProcessFlowHandler.addProcessFactory((String)"SaveData", (String)"Pre", (IServiceProcessFactory)new DataMapLogicCheckFactory());
        MidProcessFlowHandler.addProcessFactory((String)"SaveData", (String)"Pre", (String)"com.bokesoft.yes.bpm.service.BPMIndependenceFactory");
        MidProcessFlowHandler.addProcessFactory((String)"SaveData", (String)"Post", (IServiceProcessFactory)new SaveBPMDataMapFactory());
        MidProcessFlowHandler.addProcessFactory((String)"SaveData", (String)"Post", (IServiceProcessFactory)new BPMDataMigrationFactory());
        MidProcessFlowHandler.addProcessFactory((String)"SaveData", (String)"Post", (IServiceProcessFactory)new LoadBPMFactory());
        MidProcessFlowHandler.addProcessFactory((String)"DeleteData", (String)"Pre", (IServiceProcessFactory)new DataMapLogicCheckFactory());
        MidProcessFlowHandler.addProcessFactory((String)"DeleteData", (String)"Post", (IServiceProcessFactory)new KillInstancesFactory());
    }

    public void midQuartzStart(DefaultContext context) throws Throwable {
        if (!this.startWithDSN) {
            return;
        }
        LogSvr.getInstance().info("start quartz job");
        QuartzManager quartzManager = QuartzManager.getInstance();
        FileInputStream fis = PropertyUtil.readProperties((String)"quartz.properties");
        quartzManager.init(fis);
        quartzManager.addJob("SessionJob", "SessionGroup", "SessionTriggerName", "SessionTriggerGroup", (Job)new EvictExpiredSessionJob(), "check overtime session", 1200000L, -1, 900000L);
        quartzManager.addJob("DictMaintain", "DictMaintain", "DictMaintain", "DictMaintain", (Job)new DictMaintainScheduleJob(), "DictMaintain", 600000L, -1, 600000L);
        MetaBPMSetting bpmSetting = context.getVE().getMetaFactory().getSetting().getBPMSetting();
        if (bpmSetting == null || bpmSetting.isUseDefaultRetreateDelegateTimer()) {
            quartzManager.addJob("EvictExpiredDelegate", "EvictExpiredDelegate", "EvictExpiredDelegate", "EvictExpiredDelegate", (Job)new EvictExpiredDelegateJob(), "EvictExpiredDelegate", 600000L, -1, 600000L);
        }
        if (bpmSetting == null || bpmSetting.isUseDefaultExecTimeoutItemTimer()) {
            quartzManager.addJob("ExecTimeoutItem", "ExecTimeoutItem", "ExecTimeoutItem", "ExecTimeoutItem", (Job)new ExecTimeoutItemJob(), "ExecTimeoutItem", 300000L, -1, 600000L);
        }
        quartzManager.start();
        fis.close();
    }

    public void doBackgroundTask(DefaultContext context) throws Throwable {
        BackgroundTask task = new BackgroundTask();
        task.handleTask(context);
    }
}

